<?php
namespace hakoniwa\blocks\ssr\shareButtonIcon;

use hakoniwa\blocks\init\Define;

class Register {
	/**
	 * Construct.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_dynamic_block' ) );
	}

	/**
	 * ダイナミックブロック登録
	 *
	 * @return void
	 */
	public function register_dynamic_block() {
		register_block_type(
			Define::value( 'plugin_path' ) . 'build/share-button-icon',
			array(
				'render_callback' => array( $this, 'render_block' ),
			)
		);
	}

	/**
	 * レンダリング
	 *
	 * @param array $attributes 属性
	 * @return $card
	 */
	public function render_block( $attributes, $content, $block ) {

		switch ( $attributes['service'] ) {
			case 'twitter':

				$hashtags = [];

				$twitter_hashtags = apply_filters( Define::value( 'plugin_func_name' ) . '_share_twitter_hashtags', $hashtags );

				if( ! empty( $twitter_hashtags ) ){
					$twitter_hashtags = 'hashtags=' . implode( ',', $twitter_hashtags ) . '&';
				} else {
					$twitter_hashtags = '';
				}

				$share_url = "window.open('https://twitter.com/intent/tweet?" . $twitter_hashtags . "url='  + encodeURIComponent(window.location.href) + '&text=' + encodeURIComponent(document.title), '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=450,width=600');";

				$data = array(
					'name'    => 'twitter',
					'tooltip' => 'Twitter でツイートする',
					'svg'     => '<svg version="1.1" width="24" height="24" viewBox="0 0 512 512" aria-hidden="true" focusable="false"><path d="M512 113.2c-18.8 8.4-39.1 14-60.3 16.5 21.7-13 38.3-33.6 46.2-58.1-20.3 12-42.8 20.8-66.7 25.5-19.2-20.4-46.5-33.1-76.7-33.1-58 0-105 47-105 105 0 8.2 0.9 16.2 2.7 23.9-87.3-4.4-164.7-46.2-216.5-109.8-9 15.5-14.2 33.6-14.2 52.8 0 36.4 18.5 68.6 46.7 87.4-17.2-0.5-33.4-5.3-47.6-13.1 0 0.4 0 0.9 0 1.3 0 50.9 36.2 93.4 84.3 103-8.8 2.4-18.1 3.7-27.7 3.7-6.8 0-13.3-0.7-19.8-1.9 13.4 41.7 52.2 72.1 98.1 73-36 28.2-81.2 45-130.5 45-8.5 0-16.8-0.5-25.1-1.5 46.6 29.9 101.8 47.2 161.1 47.2 193.2 0 298.9-160.1 298.9-298.9 0-4.6-0.1-9.1-0.3-13.6 20.5-14.7 38.3-33.2 52.4-54.3z"/></svg>',
					'onclick' => $share_url,
				);
				break;
			case 'x':

				$hashtags = [];
				$via  = '';

				if( ! empty( $attributes['hashTags'] ) ){
					$hashtags = array_merge( $hashtags, explode( ",", $attributes['hashTags'] ) );
				}

				$x_hashtags = apply_filters( Define::value( 'plugin_func_name' ) . '_share_x_hashtags', $hashtags );

				if( ! empty( $x_hashtags ) ){
					$x_hashtags = 'hashtags=' . implode( ',', $x_hashtags ) . '&';
				} else {
					$x_hashtags = '';
				}

				if( ! empty( $attributes['via'] ) ){
					$via = $attributes['via'];
				}

				$x_via = apply_filters( Define::value( 'plugin_func_name' ) . '_share_x_via', $via );

				if( ! empty( $x_via ) ){
					$x_via = 'via=' . $x_via . '&';
				} else {
					$x_via = '';
				}

				$share_url = "window.open('https://x.com/intent/tweet?" . $x_hashtags . $x_via . "url='  + encodeURIComponent(window.location.href) + '&text=' + encodeURIComponent(document.title), '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=450,width=600');";

				$data = array(
					'name'    => 'x',
					'tooltip' => 'X にポストする',
					'svg'     => '<svg width="24" height="24" viewBox="0 0 1200 1227" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M714.163 519.284L1160.89 0H1055.03L667.137 450.887L357.328 0H0L468.492 681.821L0 1226.37H105.866L515.491 750.218L842.672 1226.37H1200L714.137 519.284H714.163ZM569.165 687.828L521.697 619.934L144.011 79.6944H306.615L611.412 515.685L658.88 583.579L1055.08 1150.3H892.476L569.165 687.854V687.828Z"/>
								</svg>',
					'onclick' => $share_url,
				);
				break;
			case 'facebook':
				$share_url = "window.open('https://www.facebook.com/sharer/sharer.php?u='  + encodeURIComponent(window.location.href), '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=450,width=600');";

				$data = array(
					'name'    => 'facebook',
					'tooltip' => 'Facebook でシェアする',
					'svg'     => '<svg version="1.1" width="24" height="24" viewBox="0 0 1030 1024" aria-hidden="true" focusable="false"><path d="M1030.262 515.131c0-284.499-230.632-515.131-515.131-515.131s-515.131 230.632-515.131 515.131c0 257.116 188.375 470.227 434.641 508.872v-359.968h-130.794v-148.904h130.794v-113.49c0-129.104 76.906-200.418 194.572-200.418 56.36 0 115.311 10.060 115.311 10.060v126.77h-64.957c-63.993 0-83.948 39.709-83.948 80.447v96.629h142.867l-22.839 148.904h-120.029v359.968c246.266-38.644 434.641-251.756 434.641-508.872z"/></svg>',
					'onclick' => $share_url,
				);
				break;
			case 'line':
				$share_url = "window.open('http://line.me/R/msg/text/?' + encodeURIComponent(document.title) + '%0D%0A' + encodeURIComponent(window.location.href), '');";

				$data = array(
					'name'    => 'line',
					'tooltip' => 'LINE で送る',
					'svg'     => '<svg version="1.1" width="24" height="24" viewBox="0 0 1024 1024" aria-hidden="true" focusable="false"><path d="M1024 439.644c0-229.109-229.678-415.5-511.996-415.5-282.301 0-512.004 186.39-512.004 415.5 0 205.392 182.146 377.415 428.192 409.938 16.676 3.578 39.369 10.993 45.118 25.238 5.155 12.944 3.367 33.222 1.651 46.289 0 0-6.009 36.125-7.31 43.841-2.219 12.944-10.285 50.638 44.354 27.612s294.863-173.625 402.279-297.278h-0.033c74.21-81.373 109.749-163.958 109.749-255.64zM331.37 561.963c0 5.513-4.456 9.984-9.96 9.984h-143.492c-2.675 0-5.090-1.065-6.887-2.789-0.049-0.049-0.098-0.082-0.146-0.13-0.065-0.065-0.106-0.122-0.146-0.171-1.724-1.789-2.789-4.22-2.789-6.887v-223.077c0-5.504 4.472-9.968 9.977-9.968h35.922c5.504 0 9.968 4.464 9.968 9.968v177.178h97.586c5.504 0 9.96 4.464 9.968 9.993v35.897zM417.947 561.98c0 5.497-4.464 9.952-9.977 9.952h-35.913c-5.504 0-9.977-4.456-9.977-9.952v-223.084c0-5.504 4.472-9.96 9.977-9.96h35.913c5.513 0 9.968 4.456 9.977 9.952v223.093zM665.188 561.98c0 5.497-4.464 9.952-9.984 9.952h-35.906c-0.878 0-1.74-0.122-2.545-0.341-0.049-0.008-0.106-0.024-0.155-0.033-0.228-0.049-0.455-0.13-0.683-0.211-0.106-0.033-0.179-0.082-0.293-0.122-0.171-0.049-0.326-0.13-0.496-0.195s-0.317-0.146-0.479-0.228c-0.106-0.049-0.187-0.098-0.268-0.162-0.219-0.113-0.431-0.219-0.618-0.374-0.033-0.033-0.082-0.057-0.113-0.082-0.967-0.643-1.838-1.456-2.536-2.456l-102.367-138.24v132.491c0 5.497-4.472 9.952-9.984 9.952h-35.906c-5.504 0-9.977-4.456-9.977-9.952v-223.084c0-5.504 4.472-9.96 9.977-9.96h35.906c0.122 0 0.228 0.016 0.35 0.016 0.171 0.008 0.341 0.016 0.512 0.033 0.179 0.016 0.35 0.033 0.521 0.065 0.146 0.016 0.284 0.033 0.423 0.057 0.195 0.040 0.382 0.082 0.577 0.13 0.122 0.033 0.228 0.049 0.341 0.082 0.204 0.065 0.39 0.122 0.594 0.195 0.113 0.033 0.204 0.082 0.317 0.113 0.204 0.073 0.39 0.162 0.577 0.244 0.106 0.049 0.204 0.106 0.309 0.155 0.179 0.089 0.357 0.195 0.528 0.301 0.113 0.057 0.204 0.113 0.301 0.179 0.179 0.113 0.341 0.235 0.512 0.35 0.089 0.073 0.179 0.13 0.26 0.204 0.179 0.138 0.366 0.293 0.528 0.447 0.057 0.057 0.113 0.113 0.171 0.171 0.211 0.195 0.415 0.399 0.61 0.618l0.073 0.057c0.26 0.326 0.537 0.658 0.772 1.008l102.245 138.061v-132.532c0-5.504 4.464-9.96 9.977-9.96h35.906c5.513 0 9.977 4.456 10.017 9.952v223.101zM863.449 374.817c0 5.521-4.447 9.977-9.96 9.977v0.008h-97.57v37.702h97.57c5.513 0 9.96 4.472 9.96 9.984v35.906c0 5.513-4.447 9.977-9.96 9.977h-97.57v37.711h97.57c5.513 0 9.96 4.464 9.96 9.984v35.922c0 5.497-4.447 9.968-9.96 9.968h-143.492c-2.658 0-5.098-1.073-6.879-2.789-0.049-0.049-0.113-0.098-0.155-0.13-0.049-0.065-0.106-0.122-0.138-0.171-1.732-1.789-2.797-4.203-2.797-6.887v-223.084c0-2.667 1.065-5.081 2.764-6.87 0.049-0.057 0.113-0.106 0.171-0.179 0.033-0.033 0.082-0.065 0.122-0.098 1.797-1.74 4.236-2.822 6.911-2.822h143.492c5.513 0 9.96 4.472 9.96 9.984v35.906z"/></svg>',
					'onclick' => $share_url,
				);
				break;
			case 'hatena':
				$share_url = "window.open('http://b.hatena.ne.jp/entry/' + encodeURIComponent(window.location.href), '');";

				$data = array(
					'name'    => 'hatena',
					'tooltip' => 'はてなブックマークに追加',
					'svg'     => '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="24" height="24" viewBox="0 0 992 1024" aria-hidden="true" focusable="false"><path d="M598.548 541.271q-49.456-55.273-137.454-61.817c52.362-14.18 90.181-34.909 114.183-62.908s35.635-64.726 35.635-111.638c0.021-1.039 0.029-2.265 0.029-3.493 0-34.826-8.902-67.574-24.554-96.091l0.522 1.039c-16.778-28.695-40.485-51.699-68.888-67.175l-0.93-0.463c-26.544-14.545-58.183-25.090-95.275-31.275s-102.183-8.726-195.274-8.726h-226.547v826.188h233.457q140.729 0 202.91-9.455c41.455-6.544 76-17.454 104.002-32.365 33.908-17.812 61.106-44.428 79.14-76.844l0.496-0.972c18.546-33.454 28.001-72.364 28.001-116.727 0-61.454-16.363-110.546-49.456-147.273zM209.455 281.633h48.364q84.001 0 112.729 18.91c19.273 12.729 28.728 34.545 28.728 65.455s-10.545 50.911-30.91 63.272-58.547 18.181-114.183 18.181h-44.726v-165.819zM401.455 755.453c-22.184 13.456-60.001 20-113.092 20h-78.91v-180.002h82.182c54.545 0 92.364 6.908 112.364 20.729s30.546 37.819 30.546 72.727-10.91 53.455-33.454 66.91z"/><path d="M887.277 715.82c-57.839 0-104.728 46.887-104.728 104.728s46.887 104.728 104.728 104.728c57.839 0 104.728-46.887 104.728-104.728v0c0-57.839-46.887-104.728-104.728-104.728v0z"/><path d="M796.368 98.723h181.818v550.985h-181.818v-550.985z"/></svg>',
					'onclick' => $share_url,
				);
				break;
			case 'pocket':
				$share_url = "window.open('http://getpocket.com/edit?url=' + encodeURIComponent(window.location.href) + '&title=' + encodeURIComponent(document.title), '');";

				$data = array(
					'name'    => 'pocket',
					'tooltip' => 'Pocket で保存する',
					'svg'     => '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="24" height="24" viewBox="0 0 1137 1024" aria-hidden="true" focusable="false"><path d="M99.481 0.102c-61.965 4.038-99.481 39.413-99.481 102.33v376.796c0 306.045 304.381 546.555 567.685 544.658 296.073-2.138 569.591-252.147 569.591-544.658v-376.796c0-63.155-39.891-98.769-102.332-102.33h-935.464zM339.283 306.62l228.402 217.007 228.646-217.007c102.327-42.973 146.963 73.84 104.938 108.030l-297.729 284.199c-9.735 9.257-61.731 9.257-71.466 0l-297.733-284.202c-40.127-37.751 12.107-156.464 104.942-108.028z"/></svg>',
					'onclick' => $share_url,
				);
				break;
			case 'copy':
				$share_url = "";

				$data = array(
					'name'    => 'copy',
					'tooltip' => 'URL をコピーする',
					'svg'     => '<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-clipboard icon-copy" width="24" height="24" viewBox="0 0 24 24" stroke-width="1" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
					<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
					<path fill="none" d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"></path>
					<rect fill="none" x="9" y="3" width="6" height="4" rx="2"></rect>
				 </svg>',
					'onclick' => $share_url,
				);
				break;
			default:
				return false;
		}

		$copied_svg = '';
		$class      = ' class="icon-type-' . $attributes['service'] . '"';
		$data_attr  = ' data-tooltip="' . $data['tooltip'] . '"';

		if ( 'copy' === $attributes['service'] ) {
			$data_attr .= ' data-copy-button data-copied="コピーしました"';
			$copied_svg = '<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-check icon-copied" width="24" height="24" viewBox="0 0 24 24" stroke-width="1" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
			<path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
			<path fill="none" d="M5 12l5 5l10 -10"></path>
		 </svg>';
		}

		$output  = '<li' . wp_kses_post( $class ) . '>';
		$output .= '<button onclick="' . htmlspecialchars( $data['onclick'] ) . '"' . wp_kses_post( $data_attr ) . '>';
		$output .= $data['svg'] . $copied_svg;
		$output .= '</button></li>';

		return $output;
	}
}

use hakoniwa\blocks\ssr\shareButtonIcon\Register;
new Register();