<?php
namespace hakoniwa\blocks\filter\timeline;

use hakoniwa\blocks\init\Define;

/**
 * ブロックフィルター
 */
class REGISTER_BLOCK_FILTER {

    /**
     * constructor.
     */
    public function __construct() {
        add_filter( 'render_block_' . Define::value( 'plugin_name' ) . '/timeline', array( $this, 'render_block' ), 10, 2 );
    }

    public function render_block( $block_content, $block ) {
        $style = '';

        //var_dump($block);

        if( array_key_exists( 'iconColor', $block['attrs'] ) ){
            $iconcolor = $block['attrs']['iconColor'];
            $blockid = $block['attrs']['blockId'];

            $style .= '.block-' . $blockid . ' .termination{';
            $style .= '--iconcolor:' . $iconcolor . ';';
            $style .= '}';
        }            
        
        if ( ! empty( $style ) ) {
            wp_add_inline_style( Define::value( 'plugin_name' ) . '-timeline-content-style', $style );
        }

        return $block_content;
    }
}

use hakoniwa\blocks\filter\timeline;
new REGISTER_BLOCK_FILTER();
