<?php
namespace hakoniwa\blocks\filter\timeline\content;

use hakoniwa\blocks\init\Define;

/**
 * ブロックフィルター
 */
class REGISTER_BLOCK_FILTER {

    /**
     * constructor.
     */
    public function __construct() {
        add_filter( 'render_block_' . Define::value( 'plugin_name' ) . '/timeline-content', array( $this, 'render_block' ), 10, 2 );
    }

    public function render_block( $block_content, $block ) {
        $custom_style = '';

        if( array_key_exists( 'iconColor', $block['attrs'] ) ){
            $iconcolor = $block['attrs']['iconColor'];

            $custom_style .= '--iconcolor:' . $iconcolor . ';';
        }

        if( array_key_exists( 'timelineBorderColor', $block['attrs'] ) ){
            $bordercolor = $block['attrs']['timelineBorderColor'];

            $custom_style .= '--bordercolor:' . $bordercolor . ';';
        }
        
        if ( ! empty( $custom_style ) ) {
            $blockid = $block['attrs']['blockId'];
            $style = '.block-' . $blockid . '{';
            $style .= $custom_style;
            $style .= '}';

            wp_add_inline_style( Define::value( 'plugin_name' ) . '-timeline-content-style', $style );
        }

        return $block_content;
    }
}

use hakoniwa\blocks\filter\timeline\content;
new REGISTER_BLOCK_FILTER();
