<?php
namespace hakoniwa\blocks\filter\howto;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\init\Utility;

/**
 * ブロックフィルター
 */
class Filter {

    /**
     * constructor.
     */
    public function __construct() {
        //add_filter( 'render_block_' . $this->plugin_name . '/howto', [ $this, 'render_block' ], 10, 3 );
        add_filter( 'wp_head', array( $this, 'json' ), 10, 3 );
    }

    /**
     * JSON-LD 出力
     *
     * @return void
     */
    public function json() {
        global $post;

        if ( is_singular() ) {
            // 投稿情報を取得
            $post_object = get_post( $post->ID );
            $blocks      = Utility::get_parse_all_blocks( $post->ID );

            //var_dump($blocks);

            $main_entity = array();

            $allowed_html = array(
                'h1'     => array(),
                'h2'     => array(),
                'h3'     => array(),
                'h4'     => array(),
                'h5'     => array(),
                'h6'     => array(),
                'br'     => array(),
                'ol'     => array(),
                'ul'     => array(),
                'li'     => array(),
                'a'      => array(
                    'href'   => array(),
                    'target' => array(),
                ),
                'p'      => array(),
                'div'    => array(),
                'b'      => array(),
                'strong' => array(),
                'i'      => array(),
                'em'     => array(),
            );

            if ( ! empty( $blocks ) ) {
                foreach ( $blocks as $block ) {
                    // 全ブロックのコンテンツ取得
                    $block_names = Utility::get_retrive_all_block_data( $block );

                    $html = '';

                    foreach ( $block_names as $block_name ) {
                        if ( Define::value('plugin_name') . '/howto' === $block_name['blockName'] ) {
                            foreach ( $block_name['innerBlocks'] as $innerblocks ) {
                                $html .= $innerblocks['innerHTML'];
                            }

                            $html = wp_kses( $html, $allowed_html );

                            if ( ! empty( $block_name['attrs']['question'] ) && ! empty( $html ) ) {
                                $main_entity[] = array(
                                    '@type'          => 'HowToStep',
                                    'name'           => $block_name['attrs']['question'],
                                    'text'           => wp_strip_all_tags( $html ),
                                );
                            }
                        }
                    }
                }
            }

            if ( ! empty( $main_entity ) ) {
                $json_array[] = array(
                    '@context'   => 'https://schema.org',
                    '@type'      => 'HowTo',
                    'step' => $main_entity,
                );

                echo "<script type='application/ld+json'>" . wp_json_encode( $json_array ) . '</script>' . "\n";
            }
        }
    }
}

use hakoniwa\blocks\filter\howto;
new Filter();
