<?php
/**
 * PHP file to use when rendering the block type on the server to show on the front end.
 *
 * The following variables are exposed to the file:
 *     $attributes (array): The block attributes.
 *     $content (string): The block default content.
 *     $block (WP_Block): The block instance.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

// Generate unique id for aria-controls.
$unique_id = wp_unique_id( 'p-' );

if ( has_post_thumbnail( get_the_ID() ) ) {
	$eyecatch = get_the_post_thumbnail_url( get_the_ID() );
} else {
	$eyecatch = '';
}

// 初期設定
$context = [
	'isOpen' => false,
	'post_id' => get_the_ID(),
	'title' => get_the_title(),
	'eyeCatch' => $eyecatch,
//	'isfavorited' => false,
];

$favorite_button_styles_output = '';
$favorite_button_styles = array();
$favorite_button_class = '';

$attributes = wp_parse_args(
	$attributes,
	array(
		'iconType' => 'heart',
	)
);

if ( isset( $attributes['color'] ) ) {
	$favorite_button_styles[] = 'color:' . $attributes['color'] . ';';
}

if( ! empty( $favorite_button_styles ) ){
	$favorite_button_styles_output = ' style="' . implode( '', $favorite_button_styles ) . '"';
}

if ( isset( $attributes['align'] ) ) {
	$favorite_button_class .= ' has-text-align-' . $attributes['align'];
}

if ( isset( $attributes['size'] ) ) {
	$favorite_button_class .= ' ' . $attributes['size'];
}

$wrapper_attributes = get_block_wrapper_attributes(
	array( 
		'class' => $favorite_button_class,
	)
);
?>
<div
	<?php echo $wrapper_attributes; ?>
	data-wp-interactive="create-block"
	<?php echo wp_interactivity_data_wp_context( $context ); ?>>
	<button
		data-wp-init="callbacks.init"
		data-wp-on-document--loaded="callbacks.loaded"
		data-wp-on--click="favorite.toggle"
		data-wp-class--favorited="context.isfavorited"
		data-wp-class--loaded="context.loaded"
		<?php echo $favorite_button_styles_output; ?>>
		<?php
		if( isset( $attributes['iconType'] ) ){
			if( 'heart' === $attributes['iconType'] ){
				echo '<svg xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="transparent"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-heart"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M19.5 12.572l-7.5 7.428l-7.5 -7.428a5 5 0 1 1 7.5 -6.566a5 5 0 1 1 7.5 6.572" /></svg>';
			} elseif( 'star' === $attributes['iconType'] ) {
				echo '<svg xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="transparent"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-star"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" /></svg>';
			}
		}
		?>		
	</button>
</div>
