<?php
namespace hakoniwa\blocks\style;

use hakoniwa\blocks\init\Define;

class Register {

    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'init', array( $this, 'register' ), 10 );
    }

    /**
     * スタイル追加
     */
    public function register() {

        require_once 'template-part.php';

        // Template Part
        $this->register_blocks_styles( 'core/template-part', $template_part_array );
        
    }

    /**
     * スタイル登録
     *
     * @param string $block_name ブロック名
     * @param array  $style_props プロパティ
     * @return void
     */
    public function register_blocks_styles( $block_name, $style_props, $prefix = '' ) {
        if ( ! empty( $block_name ) && ! empty( $style_props ) && is_array( $style_props ) ) {
            $prefix = Define::value( 'plugin_name' ) . '-';

            foreach ( $style_props as $prop ) {
                $porp_array = array(
                    'name'  => $prefix . $prop['name'],
                    'label' => $prop['label']
                );

                if( ! empty( $prop['inline_style'] ) ) {
                    $porp_array['inline_style'] = $prop['inline_style'];
                }

                if( ! empty( $prop['style_handle'] ) ) {
                    $porp_array['style_handle'] = $prop['style_handle'];
                }

                register_block_style(
                    $block_name,
                    $porp_array
                );
            }
        }
    }
}

use hakoniwa\blocks\style\Register;
new Register();
