<?php
namespace hakoniwa\blocks\ssr\breadcrumbs;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\util\Misc;

class Register {

	/**
	 * Construct.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_dynamic_block' ) );
	}

	/**
	 * ダイナミックブロック登録
	 *
	 * @return void
	 */
	public function register_dynamic_block() {
		register_block_type(
			Define::value( 'plugin_path' ) . 'build/breadcrumbs',
			array(
				'attributes'	=> array(
					'breadCrumbsHomeText'	=> array(
						'type'    => 'string',
						'default' => '',
					),
					'breadCrumbsSeparater'	=> array(
						'type'    => 'string',
						'default' => 'slash',
					),
				),
				'render_callback' => array( $this, 'block_callback' ),
			)
		);
	}

	/**
	 * レンダリング
	 *
	 * @param array $attributes 属性
	 * @return $output
	 */
	public function block_callback( $attributes, $content, $block ) {
		$output = '';

		global $wp_query;

		$queried_object = get_queried_object();
		$home_link      = get_bloginfo( 'url' );
		if ( ! empty( $attributes['breadCrumbsHomeText'] ) ) {
			$home_text = apply_filters( Define::value( 'plugin_func_name' ) . '_breadcrumbs_home_text', $attributes['breadCrumbsHomeText'] );
		} else {
			$home_text = apply_filters( Define::value( 'plugin_func_name' ) . '_breadcrumbs_home_text', __( 'Home' ) );
		}

		$current = '';

		// パンくずを入れる配列
		$bread_array = array();

		// 投稿＆固定ページ
		if ( is_singular() && ! is_front_page() ) {
			$post_type = $queried_object->post_type;
			$post_id   = $queried_object->ID;
			$parent    = $queried_object->post_parent;

			// 現在のページ
			$current = wp_kses_post( get_the_title() );

			// 固定ページ＆親ページがある場合
			if ( 0 !== $parent ) {

				// 親ページがなくなるまでループ
				while ( $parent ) {
					$post_parent = get_post( $parent );

					$bread_array[] = array(
						'permalink' => get_permalink( $post_parent->ID ),
						'title'     => get_the_title( $post_parent->ID ),
					);

					$parent = $post_parent->post_parent;
				}
			}

			// カスタム投稿タイプの場合
			if ( Misc::is_custom_post_type() ) {
				$post_type_object = get_post_type_object( $post_type );
				$post_type_link   = get_post_type_archive_link( $post_type );
				$taxonomies       = get_post_taxonomies( $post_id );
				$flag             = false;

				if ( $taxonomies ) {
					foreach ( $taxonomies as $taxonomy ) {
						$terms = get_the_terms( $post_id, $taxonomy );
						if ( $terms && ! is_wp_error( $terms ) ) {
							foreach ( $terms as $term ) {
								// var_dump( $terms );
								if ( $term->count > 0 && false === $flag ) {
									$flag = true;
									// 親タームを取得
									$term_parent = $term->parent;

									$bread_array[] = array(
										'permalink' => esc_url( get_term_link( $term->term_id ) ),
										'title'     => $term->name,
									);

									// 親のアーカイブがある場合
									if ( 0 !== $term_parent ) {
										// 親アーカイブがあるまでループして配列に入れる
										while ( $term_parent ) {
											$term = get_term( $term_parent, $taxonomy );

											$bread_array[] = array(
												'permalink' => get_term_link( $term ),
												'title' => $term->name,
											);

											$term_parent = $term->parent;
										}
									}

									// 最初に見つかったタームで処理を終わらせる
									break;
								}
							}
						}
					}

					// 投稿タイプのアーカイブ
					if ( $post_type_link ) {
						$bread_array[] = array(
							'permalink' => esc_url( $post_type_link ),
							'title'     => $post_type_object->label,
						);
					}
				}

				/*
				$bread_array[] = array(
					'permalink' => esc_url( $post_type_link ),
					'title'     => esc_html( $post_type_object->label ),
				);
				*/

				// 通常の投稿の場合
			} elseif ( 'post' === $post_type ) {
				$categories = get_the_terms( $post_id, 'category' );

				$bread_array[] = array(
					'permalink' => esc_url( get_term_link( $categories[0]->term_id ) ),
					'title'     => esc_html( $categories[0]->name ),
				);
			}
		}

		if ( is_search() ) {
			$current = '検索結果';
		} elseif ( is_archive() ) {
			$term_object = get_queried_object();

			// 投稿タイプのアーカイブページ
			if ( is_post_type_archive() ) {
				$current = esc_html( $term_object->labels->singular_name );
			}

			// カテゴリー、タグ、タクソノミーのアーカイブページ
			if ( is_category() || is_tag() || is_tax() ) {
				// Set the variables for this section
				$term_object     = get_term( $queried_object );
				$taxonomy        = $term_object->taxonomy;
				$term_name       = $term_object->name;
				$term_parent     = $term_object->parent;
				$taxonomy_object = get_taxonomy( $taxonomy );
				$taxonomy_name   = $taxonomy_object->label;

				// 親のアーカイブがある場合
				if ( 0 !== $term_parent ) {
					// 親アーカイブがあるまでループして配列に入れる
					while ( $term_parent ) {
						$term = get_term( $term_parent, $taxonomy );

						$bread_array[] = array(
							'permalink' => get_term_link( $term ),
							'title'     => $term->name,
						);

						$term_parent = $term->parent;
					}
				}

				$current = $term_name;
			}

			// 日付のアーカイブページ
			if ( is_date() ) {
				$year  = $wp_query->query_vars['year'];
				$month = $wp_query->query_vars['monthnum'];
				$day   = $wp_query->query_vars['day'];

				// 年
				if ( is_year() ) {

					$current = $year . __( 'Year' );
					// 月
				} elseif ( is_month() ) {

					// 年
					$bread_array[] = array(
						'permalink' => esc_url( get_year_link( $year ) ),
						'title'     => $year . __( 'Year' ),
					);

					$current = $month . __( 'Month' );

					// 日
				} elseif ( is_day() ) {
					// 年,月,日を入れる

					// 月
					$bread_array[] = array(
						'permalink' => esc_url( get_month_link( $year, $month ) ),
						'title'     => $month . __( 'Month' ),
					);

					// 年
					$bread_array[] = array(
						'permalink' => esc_url( get_year_link( $year ) ),
						'title'     => $year . __( 'Year' ),
					);

					$current = $day . __( 'Day' );
				}
			}

			if ( is_author() ) {
				$current = esc_html( $queried_object->data->display_name );
			}
		}

		if ( is_404() ) {
			$current = __( 'Page Not Found.', Define::value( 'plugin_name' ) );
		}

		if ( is_home() ) {
			if ( is_front_page() ) {
				if ( is_paged() ) {
					$current_page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );

					/* translators: %s: page num */
					$current = sprintf( __( 'Page %s' ), number_format_i18n( $current_page ) );
				}
			} else {
				if ( get_option( 'page_on_front' ) ) {
					if ( is_paged() ) {
						$bread_array[] = array(
							'permalink' => esc_url( get_permalink( $queried_object->ID ) ),
							'title'     => $queried_object->post_title,
						);

						$current_page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );

						/* translators: %s: page num */
						$current = sprintf( __( 'Page %s' ), number_format_i18n( $current_page ) );
					} else {
						// 投稿ページ
						$current = $queried_object->post_title;
					}
				}
			}
		}

		// 出力
		// 最後にhomeを入れる
		$bread_array[] = array(
			'permalink' => $home_link,
			'title'     => $home_text,
		);

		// 入れ替える
		$bread_array = array_reverse( $bread_array );

		// パーマリンクとテキストを変更するフィルター
		$bread_array = apply_filters( Define::value( 'plugin_func_name' ) . '_breadcrumbs_links', $bread_array );

		if ( empty( $bread_array ) ) {
			return false;
		}

		$class = '';

		if( ! empty( $attributes['breadCrumbsSeparater'] ) ){
			$class .= ' separater-' . $attributes['breadCrumbsSeparater'];
		}

		// クラス作成
		$wrapper_attributes = get_block_wrapper_attributes( 
			array( 
				'class' => $class,
			)
		);

		$bread_content_num = 1;
		$output            = '<div ' . wp_kses_post( $wrapper_attributes ) . '><ol itemscope itemtype="http://schema.org/BreadcrumbList">';
		foreach ( $bread_array as $bread ) {
			$output .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a itemprop="item" href="' . esc_url( $bread['permalink'] ) . '"><span itemprop="name">' . esc_html( $bread['title'] ) . '</span></a><meta itemprop="position" content="' . esc_attr( $bread_content_num ) . '"/></li>';

			++$bread_content_num;
		}

		$current_page = apply_filters( Define::value( 'plugin_func_name' ) . '_breadcrumbs_current_page_text', $current );

		if ( $current_page ) {
			$output .= apply_filters( Define::value( 'plugin_func_name' ) . '_breadcrumbs_current_page', '<li><span class="current">' . $current_page . '</span></li>' );
		}
		$output .= '</ol></div>';

		return $output;
	}

}

use hakoniwa\blocks\ssr\breadcrumbs;
new Register();