<?php
namespace hakoniwa\blocks\shortcode\br;

/**
 * ショートコード
 */
class REGISTER {

    /**
     * Construct
     */
    public function __construct() {
        add_shortcode( 'hakoniwa-blocks-br', array( $this, 'render_br_sc' ) );

        add_shortcode( 'hakoniwa-blocks-wbr', array( $this, 'render_wbr_sc' ) );
    }

    /**
     * ショートコード作成
     *
     * @param array $atts 属性
     *
     * @return bool|string
     */
    public function render_br_sc( $atts ) {
        // default value
        $args = shortcode_atts(
            array(
                'data-breakpoint' => ''
            ),
            $atts
        );

        if ( empty( $args['data-breakpoint'] ) ) {
            return false;
        }

        return '<br data-breakpoint="' . $args['data-breakpoint'] . '">';
    }

    /**
     * ショートコード作成
     *
     * @param array $atts 属性
     *
     * @return bool|string
     */
    public function render_wbr_sc( $atts ) {

        return '<wbr data-hakoniwa-blocks-wbr />';
    }

}

use hakoniwa\blocks\shortcode\br\REGISTER;
$output = new REGISTER();
