<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\util\Misc;

class Settings {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// 翻訳
		add_action( 'init', [ $this, 'translate' ] );

		// Add Data Attributes
		add_action( 'wp_body_open', [ $this, 'add_data_attribute_to_body' ] );

		// Block Pattern Categories
		add_action( 'init', [ $this, 'register_pattern_categories' ] );

	}
	
	/**
	 * Translate
	 */
	function translate(){
		load_plugin_textdomain( 'hakoniwa-blocks', false, Define::value( 'plugin_name' ) . '/languages' );
	}

	/**
	 * Add Data Attributes
	 */
	public function add_data_attribute_to_body() {
		echo "<script>
		
			// LocalStrage の設定
			let localThemeMode = localStorage.getItem('theme');

			let getCurrentThemeMode = currentThemeMode( localThemeMode );

			if ( getCurrentThemeMode ) {
				document.body.setAttribute( 'data-theme', getCurrentThemeMode );
			}

			// ロード時の設定を取得
			function currentThemeMode( theme ){
				if( localThemeMode !== null ){
					return theme;
				}

				if ( window.matchMedia('(prefers-color-scheme: dark)').matches ) {
					return 'dark';
				}

				return 'light';
			}
		</script>";
	}

	/**
	 * Block Pattern Categories
	 */
	public function register_pattern_categories() {

		$patterns = array();
	
		$block_pattern_categories = array(
			'hakoniwa-blocks' => array( 
				'label' => __( 'Hakoniwa Blocks', 'hakoniwa' )
			)
		);
	
		$block_pattern_categories = apply_filters( 'hakoniwa_blocks_block_pattern_categories', $block_pattern_categories );
	
		foreach ( $block_pattern_categories as $name => $properties ) {
			if ( ! \WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
				register_block_pattern_category( $name, $properties );
			}
		}
	}

}

use hakoniwa\blocks\init;
new Settings();
