<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\util\Misc;

class Update {

    private $file = '/wp/packages/plugins/hakoniwa-blocks/plugin-info.json';

    /**
     * Constructor.
     */
    public function __construct() {

        add_filter( 'plugins_api', [ $this, 'info' ], 20, 3 );

//        add_filter( 'site_transient_update_plugins', [ $this, 'update' ] );
        add_filter( 'pre_set_transient_update_plugins', [ $this, 'set_update_plugin' ] );
        add_filter( 'pre_set_site_transient_update_plugins', [ $this, 'set_update_plugin' ] );

    }

    /**
     * データ取得
     */
    private function request(){

        if( true === Define::value( 'network_active' ) ){
            
            // アクティベーションチェック
            $activate = get_option( Define::value( 'plugin_func_name' ) . '_activate' );

            if( ! isset( $activate['status'] ) ){
                return false;
            }

            if( false == $activate['status'] ){
                return false;
            }

        }

        $remote = Misc::get_update_json();

        return $remote;
    }

    /**
     * プラグイン情報作成
     */
    public function info( $res, $action, $args ) {

        if( 'plugin_information' !== $action ) {
            return $res;
        }

        if( Define::value( 'plugin_base_name' ) !== $args->slug ) {
            return $res;
        }

        $remote = $this->request();

        if( ! $remote ) {
            return $res;
        }

        $res = new \stdClass();
        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_profile;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->requires_php = $remote->requires_php;
        $res->download_link = $remote->download_url;
        $res->trunk = $remote->download_url;

        if( isset( $remote->last_updated ) ){
            $res->last_updated = $remote->last_updated;
        }

        $res->sections = [];

        if( isset( $remote->sections->description ) ){
            $res->sections['description'] = $remote->sections->description;
        }

        if( isset( $remote->sections->installation ) ){
            $res->sections['installation'] = $remote->sections->installation;
        }

        if( isset( $remote->sections->changelog ) ){
            $res->sections['changelog'] = $remote->sections->changelog;
        }

        if( isset( $remote->sections->screenshots ) ) {
            $res->sections[ 'screenshots' ] = $remote->sections->screenshots;
        }
    
        $res->banners = array(
            'low' => $remote->banners->low,
            'high' => $remote->banners->high
        );
        
        return $res;

    }

    /**
     * 更新通知（こっちを使う）
     * https://make.wordpress.org/core/2020/07/30/recommended-usage-of-the-updates-api-to-support-the-auto-updates-ui-for-plugins-and-themes-in-wordpress-5-5/
     */
    public function set_update_plugin( $transient ) {

//        var_dump($transient);
//        wp_clean_plugins_cache();

        if ( ! isset( $transient->checked ) ) {
            return $transient;
        }

        // プラグインの情報を取得
        $plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/' . Define::value( 'plugin_base_name' ) . '/index.php', false, false );

        $remote = $this->request();

        if(
            $remote
            && version_compare( $plugin_data['Version'], $remote->version, '<' )
            && version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
            && version_compare( $remote->requires_php, PHP_VERSION, '<' )
        ) {
            $res = new \stdClass();
            $res->slug = $remote->slug;
            $res->plugin = Define::value( 'plugin_base_name' ) . '/index.php';
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;
            $transient->response[ $res->plugin ] = $res;
        } else {
            // $res = new \stdClass();
            // $res->slug = Define::value( 'plugin_base_name' );
            // $res->plugin = Define::value( 'plugin_base_name' ) . '/index.php';
            // $res->new_version = $plugin_data['Version'];
            // $res->tested = '';
            // $res->package = '';
            // $transient->no_update[ $res->plugin ] = $res;
        }

        return $transient;
    }    

    /**
     * 更新通知
     */
    public function update( $transient ){
        if( ! is_admin() ){
            return false;
        }

        // プラグインの情報を取得
        $plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/' . Define::value( 'plugin_base_name' ) . '/index.php', false, false );

        if ( empty( $transient->checked ) ) {
            return $transient;
        }

        $remote = $this->request();

        // プラグインが見つかったら処理
        if(
            $remote
            && version_compare( $plugin_data['Version'], $remote->version, '<' )
            && version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
            && version_compare( $remote->requires_php, PHP_VERSION, '<' )
        ) {
            
            $res = new \stdClass();
            $res->slug = $remote->slug;
            $res->plugin = Define::value( 'plugin_base_name' ) . '/index.php';
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;
            $transient->response[ $res->plugin ] = $res;   
        }
 
        return $transient;
    
    }

}

use hakoniwa\blocks\init;
new Update();
