<?php
namespace hakoniwa\blocks\init;

class Kses {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'wp_kses_allowed_html', [ $this, 'allowed_html' ], 10, 2 );
	}

	public function allowed_html( $tags, $context ) {
		if ( 'post' === $context ) {

			$tags['img'] = array(
				'sizes'  => true,
				'src'    => true,
				'srcset' => true,
				'width'  => true,
				'height' => true,
				'class'  => true,
				'alt'    => true
			);

			$tags['time'] = array(
				'class' => true,
				'datetime' => true
			);

			$tags['svg'] = array(
				'xmlns' => array(),
				'fill' => array(),
				'viewbox' => array(),
				'role' => array(),
				'aria-hidden' => array(),
				'aria-labelledby' => array(),
				'focusable' => array(),
				'class' => array(),
				'width' => array(),
				'height' => array(),
				'style' => array(
					'width' => array(),
					'height' => array(),
					'fill' => array(),
				),
				'stroke-width' => array(),
				'stroke' => array(),
				'stroke-linecap' => array(),
				'stroke-linejoin' => array()		
			);

			$tags['defs'] = array(
				'd' => array(),
				'fill' => array()
			);

			$tags['style'] = array();
			
			$tags['g'] = array(
				'style' => array(
					'fill' => array()
				),
				'fill'      => array(),
				'transform' => array()
			);

			$tags['title'] = array();

			$tags['path'] = array(
				'class' => array(),
				'style' => array( 'fill' => array() ),
				'd'     => array(),
				'stroke-width' => array(),
				'stroke' => array(),
				'fill' => array(),
				'stroke-linecap' => array(),
				'stroke-linejoin' => array()
			);

			$tags['circle'] = array(
				'class' => array(),
				'cx' => array(),
				'cy' => array(),
				'r' => array(),
				'stroke-width' => array(),
				'stroke' => array(),
				'fill' => array(),
				'style' => array( 'fill' => array() ),
				'transform' => array()
			);

			$tags['polygon'] = array(
				'class' => array(),
				'points' => array(),
				'transform' => array()
			);

			$tags['rect'] = array(
				'class' => array(),
				'points' => array(),
				'style' => array( 'fill' => array() ),
				'transform' => array(),
				'x' => array(),
				'y'     => array(),
				'rx' => array(),
				'ry'     => array(),
				'stroke-width' => array(),
				'stroke' => array(),
				'fill' => array(),
				'width'     => array(),
				'height'     => array()
			);

			$tags['line'] = array(
				'class' => array(),
				'x1' => array(),
				'x2'     => array(),
				'y1'     => array(),
				'y2'     => array(),
				'stroke-width' => array(),
				'stroke' => array(),
				'stroke-linecap' => array(),
				'stroke-linejoin' => array()
			);
		}

		return $tags;
	}

	public static function hakoniwa_blocks_wp_kses_allowed_html() {
		$kses_post = wp_kses_allowed_html( 'post' );

		$allowed_args = array(
			'img'     => array(
				'sizes'  => true,
				'src'    => true,
				'srcset' => true,
				'width'  => true,
				'height' => true,
				'class'  => true,
				'alt'    => true
			),
			'svg'     => array(
				'style'           => array( 'fill' => true ),
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
			),
			'defs'    => true,
			'style'   => true,
			'g'       => array(
				'style'     => array( 'fill' => true ),
				'fill'      => true,
				'transform' => true,
			),
			'title'   => array( 'title' => true ),
			'path'    => array(
				'class' => true,
				'style' => array( 'fill' => true ),
				'd'     => true,
			),
			'circle'  => array(
				'class'     => true,
				'cx'        => true,
				'cy'        => true,
				'r'         => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'polygon' => array(
				'class'     => true,
				'points'    => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'rect'    => array(
				'class'     => true,
				'points'    => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'line'    => array(
				'class'  => true,
				'x1'     => true,
				'x2'     => true,
				'y1'     => true,
				'y2'     => true,
				'stroke' => true,
			),
		);

		$args = apply_filters( 'nishiki_pro_wp_kses_allow_args', $allowed_args );

		return array_merge( $kses_post, $args );
	}
}

use hakoniwa\blocks\init;
new Kses();
