<?php
namespace hakoniwa\blocks\init;

class Define {

	/**
	 * 定数
	 */
	public static function value( $name ){
		if( empty( $name ) ){
			return false;
		}

		switch( $name ){
			case 'theme_name':

				$define = 'hakoniwa';

				break;

			case 'network_auth':

				$define = 'https://hakoniwa.animagate.com';

				break;

			case 'network_active':

				$define = true;

				break;

			case 'product_id':

				$define = 'prod_OqDFSI2EsOfGQR';
//				$define = 'prod_O80B6TThIUQC24'; // テスト用

				break;	

			case 'update_json_file':

				$define = '/wp/packages/plugins/hakoniwa-blocks/plugin-info.json';

				break;
		
			case 'plugin_name':

				$define = 'hakoniwa-blocks';

				break;

			case 'plugin_func_name':

				$define = 'hakoniwa_blocks';

				break;

			case 'plugin_url':

				$define = plugin_dir_url( dirname( __DIR__ ) );

				break;
			
			case 'plugin_path':

				$define = plugin_dir_path( dirname( __DIR__ ) );

				break;

			case 'plugin_base_file':

				$define = 'index.php';

				break;

			case 'plugin_base_name':

				$define = plugin_basename( dirname( __FILE__, 3 ) );

				break;

			default:

				$define = '';

				break;
		}

		return $define;
	}	
}

