<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;

/**
 * ブロックパターン登録
 */
class Block_Pattern {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// パターン追加
		add_action( 'after_setup_theme', [ $this, 'add_block_patterns' ], 10 );
	}

	/**
	 * API URL 指定
	 */
	static function get_api_url(){
		$live = 0;

		if( $live === 1 ){
			$url = 'https://hakoniwa.animagate.com/wp-json/wp/v2/';
		} else {
			$url = 'https://final.localhost/wp-json/wp/v2/';
		}

		return $url;
	}

	/**
	 * パターン追加
	 */
	public function add_block_patterns() {

		// APIでデータ取得
		$request = self::request();
		$terms_array = [];

		if( ! $request ){
			return false;
		}

		// カテゴリー追加
		foreach( $request['all-terms']->pattern_category as $terms ){
			$terms_array[$terms->term_id] = array(
				'id' => $terms->term_id,
				'name' => $terms->name,
				'slug' => $terms->slug
			);

			register_block_pattern_category(
				Define::value( 'plugin_func_name' ) . '-' . $terms->slug,
				array( 'label' => __( 'Hakoniwa Patterns - ' . $terms->name, Define::value( 'plugin_func_name' ) ) )
			);
		}

		// パターン追加
		foreach( $request['posts'] as $data ){
			//var_dump($data);
			$id = $data->id;
			$title = $data->title->rendered;
			$raw_content = $data->pattern_preview->raw_content;
			$categories = $data->pattern_category;
			$block_pattern_categories_array = [];

			// 投稿に所属しているカテゴリーの配列を作成する
			foreach( $categories as $category_id ){
				if( in_array( $category_id, array_column( $terms_array, 'id') ) ){
					$block_pattern_categories_array[] = Define::value( 'plugin_func_name' ) . '-' . $terms_array[$category_id]['slug'];
				}
			}

			// パターンの登録
			register_block_pattern(
				'hakoniwa-blocks-patterns/' . $id,
				array(
					'title'       => __( $title, Define::value( 'plugin_func_name' ) ),
					'categories'  => $block_pattern_categories_array,
					'keywords' => [ 'hakoniwa' ],
					'content'     => $raw_content,
				)
			);
		}

	}

	public function get_patterns_posts(){
		$posts = []; // 投稿を格納する配列
		$page = 1;   // 初期ページ
	    $per_page = 1; // 1ページあたりの投稿数（最大100）
		$live = 0;

		$api_post_url = self::get_api_url();

		// APIエンドポイントにページネーションパラメータを追加
		$post_url = $api_post_url . 'patterns?_embed?per_page=' . $per_page . '&page=' . $page;

		do {
			$response = wp_remote_get(
				$post_url,
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);
	
			// エラー確認
			if(
				is_wp_error( $response )
				|| 200 !== wp_remote_retrieve_response_code( $response )
				|| empty( wp_remote_retrieve_body( $response ) )
			) {
				error_log( 'REST API Request Error: ' . $response->get_error_message() );
				break;
			}
	
			// レスポンスのボディを取得してデコード
			$data = json_decode( wp_remote_retrieve_body( $response ) );
	
			// データが空の場合は終了
			if ( empty( $data ) ) {
				break;
			}
	
			// 投稿をマージ
			$posts = array_merge( $posts, $data );
	
			// 総ページ数を取得
			$total_pages = wp_remote_retrieve_header( $response, 'X-WP-TotalPages' );
			
			$page++;

		} while ( $page <= $total_pages );

		return $posts;
	}

	public function get_patterns_terms(){
		$api_post_url = self::get_api_url();

		// APIエンドポイントにページネーションパラメータを追加
		$term_url = $api_post_url . 'all-terms';

		$response = wp_remote_get(
			$term_url,
			array(
				'timeout' => 10,
				'sslverify' => false,
				'headers' => array(
					'Accept' => 'application/json'
				)
			)
		);

		if(
			is_wp_error( $response )
			|| 200 !== wp_remote_retrieve_response_code( $response )
			|| empty( wp_remote_retrieve_body( $response ) )
		) {
			return false;
		}

		return json_decode( wp_remote_retrieve_body( $response ) );
	}

	public function request(){
		$expire_time = DAY_IN_SECONDS / 2; // DAY_IN_SECONDS:1日 | HOUR_IN_SECONDS:60分 | MINUTE_IN_SECONDS:60秒
		$key = Define::value( 'plugin_func_name' ) . '-block-pattern';

		//delete_transient( $key );
		$data = get_transient( $key );

		if( false === $data ) {

			$posts = self::get_patterns_posts();
			$all_terms = self::get_patterns_terms();
			
			$data = [];

			$data['posts'] = $posts;
			$data['all-terms'] = $all_terms;

			set_transient( $key, $data, $expire_time );
		}

		return $data;
	}
}

use hakoniwa\blocks\init;
new Block_Pattern();
