<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\util\Misc;

class Activate {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// テーマチェック
		add_action( 'plugins_loaded', [ $this, 'active_check' ] );
	}

	public function active_check(){
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}

		if( Misc::is_activate_theme() ){
			
			/**
			 * SSR 読み込み
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/ssr/index.php';

			/**
			 * ブロックフィルター
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/filter/index.php';

			/**
			 * ショートコード
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/shortcode/index.php';

			/**
			 * Rest API
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/rest-api/index.php';

			/**
			 * ブロックスタイル
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/styles/index.php';

			/**
			 * ブロックパターン
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/patterns/index.php';

			/**
			 * Init
			 */
			require_once Define::value( 'plugin_path' ) . 'inc/init/settings.php';	

			require_once Define::value( 'plugin_path' ) . 'inc/init/block-category.php';

//			require_once Define::value( 'plugin_path' ) . 'inc/init/block-pattern.php';

			require_once Define::value( 'plugin_path' ) . 'inc/init/register-block.php';

			require_once Define::value( 'plugin_path' ) . 'inc/init/kses.php';

			require_once Define::value( 'plugin_path' ) . 'inc/init/script.php';

			require_once Define::value( 'plugin_path' ) . 'inc/init/plugin-about.php';

			require_once Define::value( 'plugin_path' ) . 'inc/init/plugin-update.php';

		} else {
			// Notice
			add_action( 'admin_notices', array( $this, 'active_theme_admin_notices') );
		}

		// アップデート通知を表示
		if( $json_data = Misc::get_update_json() ){
			// プラグイン情報を取得
			$plugin_data = get_plugin_data( Define::value( 'plugin_path' ) . Define::value( 'plugin_base_file' ), false, false );

			// バージョンが大きければ通知
			if( $json_data->version > $plugin_data['Version'] ){
				// Notice
				add_action( 'admin_notices', array( $this, 'update_notices') );
			}
		}
	}

	public function active_theme_admin_notices() {
		$message = sprintf( Define::value( 'plugin_name' ) . ' を利用するには ' . Define::value( 'theme_name' ) . ' テーマを有効化してください。' );
		printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
	}

	public function update_notices() {
		$message = sprintf( Define::value( 'plugin_name' ) . ' の新しいバージョンが利用できます。プラグインを更新してください。' );
		printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
	}

}

use hakoniwa\blocks\init;
new Activate();
