<?php
namespace hakoniwa\blocks\filter\darkmode;

use hakoniwa\blocks\init\Define;

/**
 * ブロックフィルター
 */
class REGISTER_BLOCK_FILTER {

    /**
     * constructor.
     */
    public function __construct() {
        add_filter( 'render_block_' . Define::value( 'plugin_name' ) . '/dark-mode', array( $this, 'render_block' ), 10, 2 );
    }

    public function render_block( $block_content, $block ) {
        $style = '';

        $dark_mode_style        = '';

        // baseColor
        if ( ! empty( $block['attrs']['baseColor'] ) ) {
            $base_color = $block['attrs']['baseColor'];
            $dark_mode_style   .= '--wp--preset--color--base:' . $base_color . ';';
        } else {
            $dark_mode_style   .= '--wp--preset--color--base:#222222;';
        }

        // contrastColor
        if ( ! empty( $block['attrs']['contrastColor'] ) ) {
            $contrast_color = $block['attrs']['contrastColor'];
            $dark_mode_style   .= '--wp--preset--color--contrast:' . $contrast_color . ';';
        } else {
            $dark_mode_style   .= '--wp--preset--color--contrast:#c1c1c1;';
        }

        // primaryColor
        if ( ! empty( $block['attrs']['primaryColor'] ) ) {
            $primary_color = $block['attrs']['primaryColor'];
            $dark_mode_style   .= '--wp--preset--color--primary:' . $primary_color . ';';
        } else {
            $dark_mode_style   .= '--wp--preset--color--primary:#e0e0e0;';
        }

        // secondaryColor
        if ( ! empty( $block['attrs']['secondaryColor'] ) ) {
            $secondary_color = $block['attrs']['secondaryColor'];
            $dark_mode_style   .= '--wp--preset--color--secondary:' . $secondary_color . ';';
        } else {
            $dark_mode_style   .= '--wp--preset--color--secondary:#cccccc;';
        }

        // tertiaryColor
        if ( ! empty( $block['attrs']['tertiaryColor'] ) ) {
            $tertiary_color = $block['attrs']['tertiaryColor'];
            $dark_mode_style   .= '--wp--preset--color--tertiary:' . $tertiary_color . ';';
        } else {
            $dark_mode_style   .= '--wp--preset--color--tertiary:#6a6969;';
        }
        

        if( ! empty( $dark_mode_style ) ){
            $style .= '[data-theme=dark]{' . $dark_mode_style . '}';
        }
        
        if ( ! empty( $style ) ) {
            wp_add_inline_style( Define::value( 'plugin_name' ) . '-dark-mode-style', $style );
        }

        return $block_content;
    }
}

use hakoniwa\blocks\filter\darkmode;
new REGISTER_BLOCK_FILTER();
