<?php
namespace hakoniwa\blocks\util;

use hakoniwa\blocks\init\Define;

class Misc {

	/**
     * Transient 削除
     */
    public static function reset_data(){

		delete_transient( Define::value( 'plugin_func_name' ) . '_check_license' );
        delete_transient( Define::value( 'plugin_func_name' ) . '_update' );

    }
	
	/**
	 * アップデート可能かどうかチェック
	 */
	public static function get_update_json(){

        $remote = get_transient( Define::value( 'plugin_func_name' ) . '_update' );
		$file = Define::value( 'update_json_file' );

		if( false === $remote ) {
			$remote = wp_remote_get(
				Define::value( 'network_auth' ) . '/' . $file,
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);
	
			if(
				is_wp_error( $remote )
				|| 200 !== wp_remote_retrieve_response_code( $remote )
				|| empty( wp_remote_retrieve_body( $remote ) )
			) {
				return false;
			}

			$remote = json_decode( wp_remote_retrieve_body( $remote ) );
			set_transient( Define::value( 'plugin_func_name' ) . '_update', $remote, 3 * HOUR_IN_SECONDS );

		}

		return $remote;
	}

	/**
	 * テーマアクティブチェック
	 */
	public static function is_activate_theme(){
		// Theme Active Check
		$theme = get_template();

		if( $theme === Define::value( 'theme_name' ) ){
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Swiper 読み込み
	 *
	 * @return boolean
	 */
	public static function enqueue_swiper() {
		$enqueue_swiper = apply_filters(
			Define::value( 'plugin_func_name' ) . '_enqueue_swiper',
			true
		);

		if ( ! $enqueue_swiper ) {
			return false;
		}

		$url = Define::value( 'plugin_url' ) . 'assets/js/swiper/swiper-bundle.min.js';

		// Add Swiper
		wp_register_script( Define::value( 'plugin_name' ) . '-swiper', $url, array(), '1.0.0', false );
		wp_enqueue_script( Define::value( 'plugin_name' ) . '-swiper' );
	}

	/**
	 * ブロックをパース
	 */
	public static function get_parse_all_blocks( $post_id ) {

		if ( empty( $post_id ) ) {
			return false;
		}

		// 投稿情報を取得
		$post_object = get_post( $post_id );

		// コンテンツが取得できない場合はfalse
		if ( empty( $post_object->post_content ) ) {
			return false;
		}

		if ( ! has_blocks( $post_object->post_content ) ) {
			return false;
		}

		$blocks = parse_blocks( $post_object->post_content );

		// var_dump($blocks);

		return $blocks;
	}

	/**
	 * ブロックを再帰的に処理
	 */
	public static function get_retrive_all_block_data( $block_object ){
		if ( empty( $block_object ) ) {
			return false;
		}

		// ブロック名を入れる配列
		$block_objects = array();

		// ブロックが配列になければ追加する
		if ( ! in_array( $block_object['blockName'], array_column( $block_objects, 'blockName' ), true ) ) {
			$block_objects[] = $block_object;

			// var_dump($block_objects);
		}

		// インナーブロックの処理
		if ( ! empty( $block_object['innerBlocks'] ) ) {

			// var_dump($blockObject );
			foreach ( $block_object['innerBlocks'] as $inner_block ) {

				// インナーブロックを再帰的にパース
				$inner_block_objects = self::get_retrive_all_block_data( $inner_block );
//				$this->get_retrive_all_block_data();

				// 配列に格納
				$block_objects = array_merge( $block_objects, $inner_block_objects );

			}
		}

		// 再利用ブロックの処理
		if ( 'core/block' === $block_object['blockName'] ) {
			if ( ! empty( $block_object['attrs']['ref'] ) ) {

				// 再利用ブロックをパースして取得
				$reusable_blocks = self::get_parse_all_blocks( $block_object['attrs']['ref'] );

				if ( ! empty( $reusable_blocks ) ) {
					foreach ( $reusable_blocks as $reusable_block ) {

						// 全ブロック名取得
						$reusable_block_objects = self::get_retrive_all_block_data( $reusable_block );

						// 配列に格納
						$block_objects = array_merge( $block_objects, $reusable_block_objects );
					}
				}
			}
		}

		// var_dump($block_objects);

		return $block_objects;
	}

	/**
	 * カスタム投稿タイプかどうかチェック
	 *
	 * @return boolean
	 */
	static public function is_custom_post_type() {
		$post_obj = get_post_type_object( get_post_type() );
		if ( ! empty( $post_obj ) && false === $post_obj->_builtin ) {
			return $post_obj;
		} else {
			return false;
		}
	}

	/**
	 * タクソノミー全取得
	 */
	static public function get_taxonomies() {
		$builtin_taxonomy = array(
			'categories',
			'tags',
		);
		$args             = array(
			'public'   => true,
		);
		$output     = 'objects'; // names || objects
		$operator   = 'and'; // 'and' || 'or'
		$taxonomies = get_taxonomies( $args, $output, $operator );

		return $taxonomies;
	}

	/**
	 * 投稿タイプ全取得
	 */
	static function get_all_post_types() {
	
		$args = array(
			'public'   => true, // 公開している投稿タイプは表示
			'_builtin' => false // デフォルトの投稿タイプは非表示
		);

		$output   = 'names'; // 「names」で投稿タイプ名を指定
		$operator = 'and'; // 「and」で$argsの条件にどちらも合致するものだけ指定

		$post_types = get_post_types( $args, $output, $operator ); // 条件に合った投稿タイプ名を配列で取得

		$post_types_array = array( 'post', 'page' );
		foreach ( $post_types  as $post_type ) { // 取得した配列をループさせる
			$post_types_array[] = $post_type; // 投稿タイプ名を表示
		}

		return $post_types_array;
	}
}
