<?php
namespace hakoniwa\blocks\rest;

class Register {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'rest_api_init', array( $this, 'register_field' ) );
	}

	/**
	 * フィールドの登録
	 *
	 * @return void
	 */
	public function register_field() {

		// Add field.
		register_rest_field(
			$this->get_all_post_types(),
			'fse',
			array(
				'get_callback'    => array( $this, 'rest_api' ),
				'update_callback' => null,
				'schema'          => null
			)
		);
		
	}

	/**
	 * Rest API
	 *
	 * @param array $object 配列
	 * @return $rest
	 */
	public function rest_api( $object ) {

		// Term.
		// 投稿に所属するタームをすべて取得して配列に入れる
		$taxonomies = get_post_taxonomies( $object['id'] );
		if ( $taxonomies ) {
			foreach ( $taxonomies as $post_taxonomy ) {
				$terms = wp_get_post_terms( $object['id'], $post_taxonomy, array( 'fields' => 'ids' ) );

				if ( $terms ) {
					foreach ( $terms as $term ) {
						$get_term_by = get_term_by( 'id', $term, $post_taxonomy );

						if ( $get_term_by ) {
							$rest['terms'][] = $get_term_by;
						}
					}
				}
			}

			// Return REST API Data.
			if( ! empty( $rest ) ){
				return $rest;
			}
			
		} else {
			return false;
		}
	}

	// 全投稿タイプ
	public function get_all_post_types() {
	
		$args = array(
			'public'   => true, // 公開している投稿タイプは表示
			'_builtin' => false // デフォルトの投稿タイプは非表示
		);

		$output   = 'names'; // 「names」で投稿タイプ名を指定
		$operator = 'and'; // 「and」で$argsの条件にどちらも合致するものだけ指定

		$post_types = get_post_types( $args, $output, $operator ); // 条件に合った投稿タイプ名を配列で取得

		$post_types_array = array( 'post', 'page' );
		foreach ( $post_types  as $post_type ) { // 取得した配列をループさせる
			$post_types_array[] = $post_type; // 投稿タイプ名を表示
		}

		return $post_types_array;
	}

}

use hakoniwa\blocks\rest\Register;
$output = new Register();
