<?php
namespace hakoniwa\blocks\patterns;

use hakoniwa\blocks\init\Define;

class Register {
	/**
	 * constructor.
	 */
	public function __construct() {
		add_action( 'init', [ $this, 'register' ] );
	}

    /**
	 * パターン登録
	 */
	public function register() {
		$block_patterns = array(
			'header-center-contact',
			'header-phone-mail-social',
			'header-phone-mail',
			'header-phone-reception',
			'header-wide-and-search-button-with-dark-mode',
			'header-dark-phone-mail-social-button',
			'header-wide-logo-center-social-search',
			'footer-dark-mode',
			'posts-latest-posts-date-list',
			'posts-latest-posts-thumbnail-list',
			'posts-latest-posts-favorite-button',
		);
	
		/**
		 * Filters the theme block patterns.
		 *
		 * @param array $block_patterns List of block patterns by name.
		 */
		$block_patterns = apply_filters( Define::value( 'plugin_name' ) . '_block_patterns', $block_patterns );
	
		foreach ( $block_patterns as $block_pattern ) {
			$pattern_file = Define::value( 'plugin_path' ) . 'inc/patterns/' . $block_pattern . '.php';
	
			if( file_exists( $pattern_file ) ){
				register_block_pattern(
					Define::value( 'plugin_name' ) . '/' . $block_pattern,
					require $pattern_file
				);
			}
		}
	}
}

use hakoniwa\blocks\patterns;
new Register();