<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;

class Script {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'enqueue_block_assets', [ $this, 'common_assets' ] );
		add_action( 'enqueue_block_editor_assets', [ $this, 'editor_assets' ] );
		//add_action( 'wp_enqueue_scripts', [ $this, 'read_scripts' ] );

		add_action( 'init', [ $this, 'translations' ], 100 );
	}

	// フロントとエディター共通で読み込む
	public function common_assets(){

		$path = Define::value( 'plugin_url' ) . 'assets/css/plugin.css';
		$url = apply_filters( Define::value( 'plugin_func_name' ) . '_common_style', $path );

		wp_enqueue_style(
			Define::value( 'plugin_name' ) . '-common',
			$url,
			array()
		);

		// Dashiconを読み込む
		wp_enqueue_style('dashicons');
	}

	// エディターのみで読み込む
	public function editor_assets(){
	
		$path = Define::value( 'plugin_url' ) . 'assets/css/editor.css';
		$url = apply_filters( Define::value( 'plugin_func_name' ) . '_editor_style', $path );
	
		wp_enqueue_style(
			Define::value( 'plugin_name' ) . '-editor',
			$url,
			array()
		);
	}

	/**
	 * Enqueue Plugin CSS(front End)
	 *
	 * @return void
	 */
	public function read_scripts() {

		// front
		$url = plugin_dir_url( __FILE__ ) . 'assets/css/plugin.css';
		$front_end_css = apply_filters( 'fse_test_enqueue_front_end_css', $url );
		
		wp_register_style( Define::value( 'plugin_name' ) . '-front-end', $front_end_css, array(), '1.0.0', 'all' );
		wp_enqueue_style( Define::value( 'plugin_name' ) . '-front-end' );
	}

	/**
	 *　Translations
	 * 
	 */
	public function translations() {

		$block_array = [
			'breadcrumbs',
			'accordion',
			'animation',
			'balloon',
			'br',
			'broken-grid-layout',
			'broken-grid-layout-content',
			'buttons',
			'buttons-content',
			'card',
			'countdown',
			'faq',
			'filter-search',
			'filter-search-keywords',
			'filter-search-terms',
			'frame',
			'font-size',
			'icon',
			'keyboard',
			'layout',
			'layout-content',
			'marker',
			'posts',
			'rss',
			'section',
			'share-button',
			'share-button-icon',
			'slider',
			'slider-content',
			'table',
			'tabs',
			'tabs-content',
			'timeline',
			'timeline-content',
			'related-posts',
			'dark-mode',
			'favorite-button',
			'favorite-list',
		];

		foreach( $block_array as $block ){
			wp_set_script_translations( 
				'hakoniwa-blocks-' . $block . '-editor-script',
				'hakoniwa-blocks',
				Define::value( 'plugin_path' ) . 'languages'
			);
		}

    }

}

use hakoniwa\blocks\init;
new Script();
