<?php
namespace hakoniwa\blocks\init;

use hakoniwa\blocks\init\Define;

class RegisterBlock {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'init', [ $this, 'register_block_types' ], 20 );

		if ( function_exists( 'get_default_block_categories' ) && function_exists( 'get_block_editor_settings' ) ) {
			add_filter( 'block_categories_all', [ $this, 'register_block_categories' ], 10, 1 );
		} else {
			add_filter( 'block_categories', [ $this, 'register_block_categories' ], 10, 1 );
		}

		add_action( 'init', [ $this, 'localize_script' ], 10 );

	}

	public function register_block_types(){
		global $wp_version;

		$plugin_path = Define::value( 'plugin_path' );

		register_block_type( $plugin_path . 'build/filter' );

		register_block_type( $plugin_path . 'build/share-button' );

		register_block_type( $plugin_path . 'build/faq' );

		register_block_type( $plugin_path . 'build/balloon' );

		register_block_type( $plugin_path . 'build/countdown' );

		register_block_type( $plugin_path . 'build/frame' );

		register_block_type( $plugin_path . 'build/animation' );

		register_block_type( $plugin_path . 'build/accordion' );

		register_block_type( $plugin_path . 'build/br' );

		register_block_type( $plugin_path . 'build/broken-grid-layout' );

		register_block_type( $plugin_path . 'build/broken-grid-layout-content' );

		register_block_type( $plugin_path . 'build/icon' );

		register_block_type( $plugin_path . 'build/timeline' );

		register_block_type( $plugin_path . 'build/timeline-content' );

		register_block_type( $plugin_path . 'build/tabs' );

		register_block_type( $plugin_path . 'build/tabs-content' );

		register_block_type( $plugin_path . 'build/layout' );

		register_block_type( $plugin_path . 'build/layout-content' );

		register_block_type( $plugin_path . 'build/marker' );

		register_block_type( $plugin_path . 'build/slider' );

		register_block_type( $plugin_path . 'build/slider-content' );

		register_block_type( $plugin_path . 'build/buttons' );

		register_block_type( $plugin_path . 'build/buttons-content' );

		register_block_type( $plugin_path . 'build/section' );

		register_block_type( $plugin_path . 'build/keyboard' );

		register_block_type( $plugin_path . 'build/table' );

		register_block_type( $plugin_path . 'build/filter-search' );

		register_block_type( $plugin_path . 'build/related-posts' );

		register_block_type( $plugin_path . 'build/dark-mode' );

		register_block_type( $plugin_path . 'build/hakoniwa-patterns' );

		if ( version_compare( $wp_version, '6.5', '>=' ) ) {
			register_block_type( $plugin_path . 'build/favorite-button' );
			register_block_type( $plugin_path . 'build/favorite-list' );
		}

		register_block_type( $plugin_path . 'build/font-size' );

		register_block_type( $plugin_path . 'build/inline-icons' );

	}

	/**
	 * ブロックカテゴリー追加
	 *
	 * @param array $categories Array of categories for block types.
	 */
	public function register_block_categories( $categories ) {
		array_unshift( $categories, array(
			'slug'  => Define::value( 'plugin_name' ),
			'title' => __( 'Hakoniwa Blocks',  Define::value( 'plugin_name' ) )
		) );
/*
		return array_merge(
			$categories,
			array(
				array(
					'slug'  => Define::value( 'plugin_name' ),
					'title' => __( 'Hakoniwa Blocks',  Define::value( 'plugin_name' ) ),
				),
			)
		);
*/

		return $categories;
	}

	/**
	 * Localize Script 追加
	 */
	public function localize_script(){
		wp_localize_script(
			'jquery',
			Define::value( 'plugin_func_name' ) . '_scripts_data',
			array(
				'home_url' => home_url( '/' )
			)
		);
	}
	
}

use hakoniwa\blocks\init;
new RegisterBlock();
