<?php
namespace hakoniwa\blocks\filter\tabs;

use hakoniwa\blocks\init\Define;

/**
 * ブロックフィルター
 */
class REGISTER_BLOCK_FILTER {

    /**
     * constructor.
     */
    public function __construct() {
        add_filter( 'render_block_' . Define::value( 'plugin_name' ) . '/tabs', array( $this, 'render_block' ), 10, 2 );
    }

    public function render_block( $block_content, $block ) {
        $style = '';

        $id = $block['attrs']['blockID'];

        $tab_title_style        = '';
        $tab_title_active_style = '';
        $tab_content_style      = '';

        // Root Id
        if ( ! empty( $id ) ) {
            $root_style = '#block-' . $id;
        }

        //
        // Tab Titles
        //

        // Tab Titles Button
        if ( ! empty( $block['attrs']['tabTitleBgColor'] ) ) {
            $tab_title_bg_color = $block['attrs']['tabTitleBgColor'];
            $tab_title_style   .= 'background-color:' . $tab_title_bg_color . ';';
        }

        if ( ! empty( $block['attrs']['tabTitleTextColor'] ) ) {
            $tab_title_text_color = $block['attrs']['tabTitleTextColor'];
            $tab_title_style     .= 'color:' . $tab_title_text_color . ';';
        }

        // Tab Titles Button(active)
        if ( ! empty( $block['attrs']['tabTitleActiveBgColor'] ) ) {
            $tab_title_active_bg_color = $block['attrs']['tabTitleActiveBgColor'];
            $tab_title_active_style   .= 'background-color:' . $tab_title_active_bg_color . ';';
        }

        if ( ! empty( $block['attrs']['tabTitleActiveTextColor'] ) ) {
            $tab_title_active_text_color = $block['attrs']['tabTitleActiveTextColor'];
            $tab_title_active_style     .= 'color:' . $tab_title_active_text_color . ';';
        }

        // Tab Border Color
        if ( ! empty( $block['attrs']['tabTitleBorderColor'] ) ) {
            $tab_title_border_color = $block['attrs']['tabTitleBorderColor'];
            $tab_title_style       .= 'border-color:' . $tab_title_border_color . ';';
        }

        //
        // Tab Contents
        //

        // Tab Bg Color
        if ( ! empty( $block['attrs']['tabContentBgColor'] ) ) {
            $tab_content_bg_color = $block['attrs']['tabContentBgColor'];
            $tab_content_style   .= 'background-color:' . $tab_content_bg_color . ';';
        }

        // Tab Border Color
        if ( ! empty( $block['attrs']['tabContentBorderColor'] ) ) {
            $tab_content_border_color = $block['attrs']['tabContentBorderColor'];
            $tab_content_style       .= 'border-color:' . $tab_content_border_color . ';';
        }

        // Styles

        // Tab Title
        if ( ! empty( $tab_title_bg_color ) || ! empty( $tab_title_text_color ) || ! empty( $tab_title_border_color ) ) {
            $style .= $root_style . ' .tabs button{' . $tab_title_style . '}';
        }

        if ( ! empty( $tab_title_active_bg_color ) || ! empty( $tab_title_active_text_color ) ) {
            $style .= $root_style . ' .tabs button.active{' . $tab_title_active_style . '}';
        }

        // Tab Vertical
        if ( ! empty( $block['attrs']['tabTitleWidth'] ) ) {
            $tab_title_width = $block['attrs']['tabTitleWidth'];

            $style .= '@media only screen and (min-width: 769px){' . $root_style . ' .tab-titles{flex-basis:' . $tab_title_width . 'px;}}';
        }

        // Tab Contents
        if ( $tab_content_style ) {
            $style .= $root_style . ' .tab-contents{' . $tab_content_style . '}';
        }
        
        if ( ! empty( $style ) ) {
            wp_add_inline_style( Define::value( 'plugin_name' ) . '-tabs-content-style', $style );
        }

        return $block_content;
    }
}

use hakoniwa\blocks\filter\tabs;
new REGISTER_BLOCK_FILTER();
