<?php
namespace hakoniwa\blocks\filter\core\queryLoop\relatedPosts;

use hakoniwa\blocks\init\Define;
use hakoniwa\blocks\util\Misc;

// ブロックを追加する場所によって挙動を変える
// 投稿タイプの場合・・・「関連する投稿を表示」現在の投稿 id が取得できる投稿タイプの場合
// サイトエディターの場合・・・「関連する投稿を表示」エディター側では非表示はまずい（テンプレート編集の強みがなくなるから）。
// 投稿タイプだけ変えられるようにする。フロント側のみ反映

/**
 * ブロックフィルター
 */
class REGISTER_BLOCK_FILTER {

    /**
     * constructor.
     */
    public function __construct() {
        add_filter( 'pre_render_block', array( $this, 'render_block' ), 100, 2 );

        add_action( 'wp_loaded', function(){
            //投稿タイプ全てにクエリーをフィルターする
            $all_post_types = Misc::get_all_post_types();

            foreach( $all_post_types as $post_type ){
                add_filter( 'rest_' . $post_type . '_query', array( $this, 'query' ), 100, 2 ); 
            }    
        });
    }

    // エディター側
    public function query( $args, $request ){
        
        // カスタムした属性を取得
//        $sameterm = $request->get_param( 'isSameTerm' );

        if( 'true' == $request['isRelatedPosts'] && ! empty( $request['currentPostId'] ) ){

            // 投稿IDと選択した投稿タイプが同じ場合と違う場合があるので処理を分ける
            $select_post_type = $args['post_type']; //選択した投稿タイプ
            $current_post_type = get_post_type( $request['currentPostId'] ); //投稿IDが所属する投稿タイプ
            
            $related_args = $this->related_posts( $request['currentPostId'], $select_post_type );
            $args = array_merge( $args, $related_args );

        }

        return $args;
    }

    // フロント側
    public function render_block( $pre_render, $parsed_block ) {
        // Verify it's the block that should be modified using the namespace
        if ( ! empty($parsed_block['attrs']['namespace']) && 'hakoniwa-blocks/related-posts' === $parsed_block['attrs']['namespace'] ) {
		    
            add_filter(
                'query_loop_block_query_vars',
                function( $query, $block ) use ( $parsed_block ) {

                    if( $parsed_block['attrs']['query']['isRelatedPosts'] && ! empty( $parsed_block['attrs']['query']['currentPostId'] ) ){

                        $select_post_type = $query['post_type']; //選択した投稿タイプ
                        //var_dump($query['post_type']);

                        $related_args = $this->related_posts( $parsed_block['attrs']['query']['currentPostId'], $select_post_type );
                        $query = array_merge( $query, $related_args );
                    }

//                    var_dump($query);
                    
                    return $query;
                }, 10, 2
            );
        }
        return $pre_render;
    }

    // 関連記事表示
    public function related_posts( $post_id = '', $post_type = '' ){

        if( empty ( $post_id ) ){
            return false;
        }

        $args = array();
        $tax_query = array();

		$exclude_post_id = array( $post_id );

        // 投稿タイプに紐づいているタクソノミー取得
        $taxonomies = get_object_taxonomies( $post_type, 'object' );
        if( $taxonomies ){
            foreach ( $taxonomies as $taxonomy ) {

                // タクソノミーごとに紐づくtermのidを取得
                $terms = wp_get_post_terms( $post_id, $taxonomy->name, array( 'fields' => 'ids' ) );
    
                // tax_queryに追加
                if( $terms ){
                    $tax_query[] = array(
                        'taxonomy' => $taxonomy->name,
                        'field'    => 'term_id',
                        'terms'    => $terms,
                    );    
                }
  
            }

            if( $tax_query ){
                $args['tax_query'] = array(
                    'relation' => 'OR',
                    $tax_query,
                );    
            }
        }

        $args['post__not_in'] = $exclude_post_id;

        return $args;
    }
}

use hakoniwa\blocks\filter\core\queryLoop\relatedPosts;
new REGISTER_BLOCK_FILTER();
