<?php
namespace hakoniwa\tools\util;

use hakoniwa\tools\init\Define;
use hakoniwa\theme\util\Functions;

class DefaultOptions {

	/**
	 * Default Settings
	 *
	 * @var array
	 */
	public static function general_settings(){
		return array(
			'content_size' => '640px',
			'wide_size'    => '960px',
			'scroll_to_button' => [
				'desktop' => 1,
				'tablet' => 1,
				'smartphone' => 1,
			],
		);
	}

	

	/**
	 * プラグイン有効後 初期設定
	 *
	 * @return void
	 */
	public static function setting_options() {

		$default_options = [
			'general' => self::general_settings(),
			'meta' => [
				'active' => [
					'ogp' => 1,
					'twitter' => 1,
					'facebook' => 1,
				],
				'twitter_card_type' => 'summary_large_image',
			],
			'schema_org' => [
				'post_type' => [
					'post' => 1,
					'page' => 1,
				],
				'page_type' => 'BlogPosting',
			],
			'toc' => [
				'toc_enable' => 1,
				'toc_fixed_enable' => 1,
				'toc_heading_level' => 3,
				'toc_heading_level_number' => 4,
				'toc_label' => __( 'Table of Contents', 'hakoniwa-tools' ),
			]
		];

		foreach ( $default_options as $key => $value ) {
			$option_name = Define::value( 'theme_options_name' ) . '_' . $key;
			$current_value = get_option( $option_name, null );

			if ( is_array( $value ) ) {

				// 配列オプションの場合、既存の設定を維持しつつデフォルト値を補完
				$current_value = is_array( $current_value) ? $current_value : [];
				$merged_value = array_merge( $value, $current_value );

				update_option( $option_name, $merged_value );
			} else {

				// 通常のオプション
				if ( $current_value === null ) {
					update_option( $option_name, $value );
				}
			}

			//delete_option($option_name);
			//var_dump(get_option( $option_name, null ));

		}

	}

}
