<?php
namespace hakoniwa\tools\options;

use hakoniwa\tools\init\Define;

class Menu {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'admin_menu' ], 10 );
	}
	
	/**
	 * メニュー追加
	 */
	public function admin_menu() {
		add_menu_page(
			'Hakoniwa Tools',
			'Hakoniwa Tools',
			'manage_options',
			Define::value( 'theme_name' ) . '-tools.php',
			[ $this, 'create_page' ],
			Define::value( 'plugin_url' ) . '/assets/images/hakoniwa-logo-w.svg'
		);
	}

	/**
	 * 表示するタブ
	 *
	 * @var array
	 */
	public function tab_array(){

		$tab_array = array(
			'general'         	=> __( 'General', 'hakoniwa-tools' ),
			'top'         		=> __( 'Top page', 'hakoniwa-tools' ),
			'analytics'         => __( 'Analytics', 'hakoniwa-tools' ),
			'script'      		=> __( 'Script', 'hakoniwa-tools' ),
			'optimize'    		=> __( 'Optimize', 'hakoniwa-tools' ),
	//		'infeed_ads'  		=> __( 'インフィード広告', 'hakoniwa-tools' ),
			'meta'        		=> __( 'Meta', 'hakoniwa-tools' ),
			'schema_org'        => __( 'Schema.org', 'hakoniwa-tools' ),
			'redirect'    		=> __( 'Redirect', 'hakoniwa-tools' ),
			'login'         	=> __( 'Login', 'hakoniwa-tools' ),
			'css'         		=> __( 'Css', 'hakoniwa-tools' ),
			'toc'         		=> __( 'Table of contents', 'hakoniwa-tools' ),
		);

		return $tab_array;
	}

	/**
	 * タブ出力
	 */
	public function create_tab() {
		$admin_url  = 'admin.php?page=' . Define::value( 'theme_name' ) . '-tools.php';
		$flag       = false;
		$tab_array  = $this->tab_array();
		$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

		echo '<div class="hakoniwa-tools-wrapper flex flex-col mr-4 self-baseline sticky top-8">';
		foreach ( $tab_array as $key => $val ) {
			$active = '';
			if ( ! isset( $get_action ) && false === $flag ) {
				$active = ' active';
				$flag   = 1;
			} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
				$active = ' active';
			}

			if( empty( $get_action ) && 'general' == $key ){
				$active = ' active';
			}

			echo '<a href="' . esc_url(
				add_query_arg(
					array(
						'action' => $key,
					),
					$admin_url
				)
			) . '" class="py-2 px-4' . esc_attr( $active ) . '">' . esc_html( $val ) . '</a>';
		}

		echo '</div>';
	}

	/**
	 * 設定画面出力
	 */
	public function create_setting() {
		$tab_array  = $this->tab_array();
		$flag       = false;
		$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

		foreach ( $tab_array as $key => $val ) {
			if ( ! isset( $get_action ) && false === $flag ) {
				$flag = true;
			} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
				$flag = true;
			}

			if ( true === $flag ) {
				settings_fields( Define::value( 'theme_options_name' ) . '_' . $key );
				do_settings_sections( Define::value( 'theme_options_name' ) . '_' . $key );

				submit_button();

				break;
			}
		}

		if( false === $flag ){
			settings_fields( Define::value( 'theme_options_name' ) . '_general' );
			do_settings_sections( Define::value( 'theme_options_name' ) . '_general' );

			submit_button();
		}
	}

	/**
	 * オプションページの内容
	 */
	public function create_page() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'このページを表示する権限がありません。' );
		}
		?>
			<div class="wrap">
				<h1>設定</h1>
					<div class="flex">
						<?php $this->create_tab(); ?>
						<div class="flex-1">
							<form method="post" action="options.php">
								<?php $this->create_setting(); ?>
							</form>
						</div>
					</div>
			</div>
		<?php
	}
}

use hakoniwa\tools\options;
new Menu();
