<?php
namespace hakoniwa\tools\init;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\TOC;
use hakoniwa\tools\util\Misc;

class Settings {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// theme.json の上書き
		add_filter( 'wp_theme_json_data_theme', [ $this, 'override_theme_json' ], 10, 2 );

		// カスタムテンプレートの設定
//		add_filter( 'default_template_types', [ $this, 'custom_templates' ], 10 );

		// デフォルトサムネイルの変更
		add_filter( 'hakoniwa_default_thumbnail', [ $this, 'custom_default_thumbnail' ], 10 );

		// Footer Content
		add_action( 'wp_footer', [ $this, 'footer_content' ], 10 );

		// TOC
		add_filter( 'the_content', [ new TOC, 'add_toc_anchor' ] );
		add_action( 'fixed_content', [ new TOC, 'add_toc_fixed_content' ] );
		
		// 翻訳
		add_action( 'init', [ $this, 'translate' ] );

		// nofollow,noindex
		add_action( 'wp_head', [ $this, 'add_noindex_nofollow' ], 1 );
	}

	/**
	 * オプション設定
	 */
	public function add_noindex_nofollow() {

		if ( is_singular() ) {
			global $post;
			setup_postdata( $post );

			$post_setting_array = array();

			$post_noindex  = get_post_meta( get_the_ID(), '_' . Define::value( 'plugin_func_name' ) . '_meta_box_noindex_' . get_post_type(), true );
			$post_nofollow = get_post_meta( get_the_ID(), '_' . Define::value( 'plugin_func_name' ) . '_meta_box_nofollow_' . get_post_type(), true );

			if ( ! empty( $post_noindex ) ) {
				$post_setting_array[] = 'noindex';
			}

			if ( ! empty( $post_nofollow ) ) {
				$post_setting_array[] = 'nofollow';
			}

			if ( ! empty( $post_setting_array ) ) {
				echo '<meta name="robots" content="' . esc_html( trim( implode( ',', $post_setting_array ) ) ) . '">';
			}

			wp_reset_postdata();
		}

	}

	/**
	 * theme.json の上書き
	 */
	public function override_theme_json( $theme_json ) {

		$general_options = get_option( Define::value( 'theme_options_name' ) . '_general' );

		if( $general_options ){
			$new_data = array(
				'version' => 3,
				'settings' => array(
					'layout' => array(
						'contentSize' => $general_options['content_size'],
						'wideSize' => $general_options['wide_size']
					)
				),
			);
		
			return $theme_json->update_with( $new_data );
		}

		return $theme_json;
	}

	/**
	 * カスタムテンプレートの設定
	 */
	public function custom_templates( $default_template_types ){

		$default_template_types['content-only'] = array(
			'title'       => __( '[Hakoniwa]:Content only', Define::value( 'theme_name' ) ),
			'description' => __(
				'ヘッダー/フッターを非表示にして、本文のコンテンツのみ表示したいときに使えるテンプレートです。',
				Define::value( 'theme_name' )
			),
		);

		$default_template_types['single-2-columns'] = array(
			'title'       => __( '[Hakoniwa]:Single 2 columns', Define::value( 'theme_name' ) ),
			'description' => __(
				'2カラムレイアウトのテンプレートです。',
				Define::value( 'theme_name' )
			),
		);

		$default_template_types['single-without-title'] = array(
			'title'       => __( '[Hakoniwa]:Single without title', Define::value( 'theme_name' ) ),
			'description' => __(
				'タイトルを非表示にしたいときに使えるテンプレートです。',
				Define::value( 'theme_name' )
			),
		);

		return $default_template_types;
	}


	/**
	 * デフォルトサムネイル
	 *
	 * @return void
	 */
	public function custom_default_thumbnail( $html ){
		$options = get_option( Define::value( 'theme_options_name' ) . '_meta' );

		if ( isset( $options['og_image'] ) ) {

			$image_data = wp_get_attachment_image_src( $options['og_image'], 'thumbnail' );

			if ( $image_data ) {
				$image_thumbnail = $image_data[0];
				$thumbnail       = $image_thumbnail;
			}

			if( ! empty( $image_thumbnail ) ){
				$html = '<div class="no-image"><img alt="" src="' . $image_thumbnail . '"></div>';
			}

		}

		return $html;
	}

	/** right_bottom_content */
	public function footer_content(){
		do_action( 'fixed_content' );
	}

	/**
	 * Translate
	 */
	public function translate(){
		load_plugin_textdomain( 'hakoniwa-tools', false, Define::value( 'plugin_name' ) . '/languages' );
	}

}

use hakoniwa\tools\init;
new Settings();
