<?php
namespace hakoniwa\tools\init;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\Misc;
use hakoniwa\tools\util\TOC;

class FixedContent {

	/**
	 * Constructor.
	 */
	public function __construct() {

		add_action( 'fixed_content', [ $this, 'footer_content' ], 10 );

	}

	/** right_bottom_content */
	public function footer_content(){
		$general_options = get_option( Define::value( 'theme_options_name' ) . '_general' );
		$toc_options = get_option( Define::value( 'theme_options_name' ) . '_toc' );

		if( ! empty( $general_options['scroll_to_button'] ) || ! empty( $toc_options['toc_fixed_enable'] ) ){
			$output = '<div class="footer-bottom-right-content fixed">';
			if( true === TOC::has_toc() ){
				$output .= self::toc_button();
			}
			$output .= self::scroll_page_top_button();
			$output .= '</div>';

			echo wp_kses_post( $output );
		}
	}

	/**
	 * ページトップボタン
	 *
	 * @return void
	 */
	function scroll_page_top_button() {

		if ( ! apply_filters( Define::value( 'theme_options_name' ) . '_scroll_page_top_button', true ) ) {
			return;
		}

		$output = '';
		$url    = apply_filters( Define::value( 'theme_options_name' ) . '_scroll_page_top_url', '#header' );
		$class  = [];

		$options = get_option( Define::value( 'theme_options_name' ) . '_general' );

		if( ! empty( $options['scroll_to_button'] ) ){
			if( isset( $options['scroll_to_button']['desktop'] ) ){
				$class[] = 'is-desktop';
			}

			if( isset( $options['scroll_to_button']['tablet'] ) ){
				$class[] = 'is-tablet';
			}

			if( isset( $options['scroll_to_button']['smartphone'] ) ){
				$class[] = 'is-smartphone';
			}
		}

		if( empty( $class ) ){
			return false;
		}

		$kses_defaults = wp_kses_allowed_html( 'post' );

		$svg_args = array(
			'svg'   => array(
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
				'stroke-width'    => true,
				'stroke'          => true,
				'fill'            => true,
				'stroke-linecap'  => true,
				'stroke-linejoin' => true,
			),
			'g'     => array(
				'fill'      => true,
				'transform' => true,
			),
			'title' => array( 'title' => true ),
			'path'  => array(
				'stroke' => true,
				'd'      => true,
				'fill'   => true,
			),
		);

		$allowed_tags = array_merge( $kses_defaults, $svg_args );

		$bottom_right_content = '<div id="scroll-page-top" class="' . implode( ' ', $class ) . '"><a class="icon-wrapper" href="' . $url . '">
			<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-up" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
				<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
				<path d="M6 15l6 -6l6 6" />
			</svg>
		</a></div>';

		$bottom_right_content = apply_filters( Define::value( 'theme_options_name' ) . '_bottom_right_content', $bottom_right_content, $url );

		$output .= apply_filters( Define::value( 'theme_options_name' ) . '_before_bottom_right_content', $before_bottom_right_content = '' );
		$output .= $bottom_right_content;
		$output .= apply_filters( Define::value( 'theme_options_name' ) . '_after_bottom_right_content', $after_bottom_right_content = '' );

		return wp_kses( $output, $allowed_tags );
	}

	/**
	 * TOC Button
	 *
	 * @return void
	 */
	function toc_button() {

		if( ! is_single() ){
			return false;
		}

		if ( ! apply_filters( Define::value( 'theme_options_name' ) . '_toc_button', true ) ) {
			return;
		}

		$output = '';
		$class  = [];

		$options = get_option( Define::value( 'theme_options_name' ) . '_toc' );

		if( empty( $options['toc_fixed_enable'] ) ) {
			return false;
		}

		$kses_defaults = wp_kses_allowed_html( 'post' );

		$svg_args = array(
			'svg'   => array(
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
				'stroke-width'    => true,
				'stroke'          => true,
				'fill'            => true,
				'stroke-linecap'  => true,
				'stroke-linejoin' => true,
			),
			'g'     => array(
				'fill'      => true,
				'transform' => true,
			),
			'title' => array( 'title' => true ),
			'path'  => array(
				'stroke' => true,
				'd'      => true,
				'fill'   => true,
			),
		);

		$allowed_tags = array_merge( $kses_defaults, $svg_args );

		$bottom_right_content = '<div id="fixed-toc" class="' . implode( ' ', $class ) . '"><span class="icon-wrapper">
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-list"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M9 6l11 0"></path><path d="M9 12l11 0"></path><path d="M9 18l11 0"></path><path d="M5 6l0 .01"></path><path d="M5 12l0 .01"></path><path d="M5 18l0 .01"></path></svg>
		</span></div>';

		$output .= apply_filters( Define::value( 'theme_options_name' ) . '_before_toc_bottom_right_content', $before_bottom_right_content = '' );
		$output .= $bottom_right_content;
		$output .= apply_filters( Define::value( 'theme_options_name' ) . '_after_toc_bottom_right_content', $after_bottom_right_content = '' );

		return wp_kses( $output, $allowed_tags );
	}

}

use hakoniwa\tools\init;
new FixedContent();
