<?php
namespace hakoniwa\tools\options;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;

class TopPage {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'register_settings' ], 10 );

		// タイトル変更
		add_filter( 'document_title_parts', [ $this, 'change_top_title' ] );

		// ディスクリプション追加
		add_action( 'wp_head', [ $this, 'change_description' ], 1 );
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return Define::value( 'theme_options_name' ) . '_top';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {
		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			'title',
			__( 'Title', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'type'        => 'text',
				'title'       => '',
				'label'       => 'title',
				'page_name'   => $this->page_name(),
				'description' => __( 'Change the title of the top page.', 'hakoniwa-tools' ),
			)
		);

		add_settings_field(
			'description',
			__( 'Description', 'hakoniwa-tools' ),
			array( $create_form, 'textarea' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'type'        => 'textarea',
				'title'       => '',
				'label'       => 'description',
				'page_name'   => $this->page_name(),
				'description' => __( 'Change the top page description. Write a clear description of the site features.', 'hakoniwa-tools' ),
			)
		);
	}

	/**
	 * 入力値のサニタイズ
	 *
	 * @param array $input Contains all settings fields as array keys
	 */
	public function sanitize( $input ) {
		$new_input = array();

		if ( isset( $input ) ) {
			foreach ( $input as $key => $val ) {
				// 配列の場合
				if ( is_array( $input[ $key ] ) ) {
					$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
				} else {
					// 通常の場合
					$new_input[ $key ] = stripslashes( $input[ $key ] );
				}
			}
		}

		// wp_die(var_dump($new_input));
		return $new_input;
	}

	/**
	 * トップページのタイトル変更
	 */
	function change_top_title( $title ) {
		$options = get_option( $this->page_name() );
		if ( ! empty( $options['title'] ) && ( is_home() || is_front_page() ) ) {
			$title['title']   = $options['title'];
			$title['site']    = '';
			$title['tagline'] = '';
		}

		return $title;
	}

	/**
	 * ディスクリプション変更
	 */
	function change_description() {
		$content = '';

		if ( is_home() || is_front_page() ) {
			$options = get_option( $this->page_name() );
			if ( ! empty( $options['description'] ) ) {
				$content = esc_attr( $options['description'] );
			} else {
				$content = esc_attr( get_bloginfo( 'description' ) );
			}
		}

		if ( is_singular() && ! is_front_page() ) {
			global $post;
			setup_postdata( $post );

			if ( ! empty( get_the_excerpt() ) ) {
				$content = esc_attr( get_the_excerpt() );
			}

			wp_reset_postdata();
		}

		// Archive
		if ( is_category() || is_tag() || is_tax() ) {
			if ( ! empty( term_description() ) ) {
				$content = str_replace( PHP_EOL, '', wp_strip_all_tags( term_description() ) );
			}
		}

		if ( ! empty( $content ) ) {
			echo '<meta name="description" content="' . $content . '">' . "\n"; // phpcs:ignore
		}

	}

}

use hakoniwa\tools\options;
new TopPage();
