<?php
namespace hakoniwa\tools\options;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;
use hakoniwa\tools\util\Misc;

class Script {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'register_settings' ], 10 );

		$this->script();
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return Define::value( 'theme_options_name' ) . '_script';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {
		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			'enable',
			__( 'Enable', 'hakoniwa-tools' ),
			array( $create_form, 'checkbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => __( 'Enable', 'hakoniwa-tools' ),
				'label'       => 'enable',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'header',
			__( 'Add script to header', 'hakoniwa-tools' ),
			array( $create_form, 'textarea' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'header',
				'page_name'   => $this->page_name(),
				'description' => __( 'Output priority (default: 10) in the range of 1 to 999. The lower the number, the higher the priority of execution.', 'hakoniwa-tools' ),
				'priority'    => true,
			)
		);

		add_settings_field(
			'body_open',
			__( 'Add script immediately after&lt;body&gt; tag', 'hakoniwa-tools' ),
			array( $create_form, 'textarea' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'body_open',
				'page_name'   => $this->page_name(),
				'description' => __( 'Output priority (default: 10) in the range of 1 to 999. The lower the number, the higher the priority of execution.', 'hakoniwa-tools' ),
				'priority'    => true,
			)
		);

		add_settings_field(
			'footer',
			__( 'Add script to footer', 'hakoniwa-tools' ),
			array( $create_form, 'textarea' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'footer',
				'page_name'   => $this->page_name(),
				'description' => __( 'Output priority (default: 10) in the range of 1 to 999. The lower the number, the higher the priority of execution.', 'hakoniwa-tools' ),
				'priority'    => true,
			)
		);
	}

	/**
	 * 入力値のサニタイズ
	 *
	 * @param array $input Contains all settings fields as array keys
	 */
	public function sanitize( $input ) {
		$new_input = array();

		// サニタイズの汎用化

		// 配列かどうか
		// 値が整数ならabsint、テキストなら
		// チェックボックス absint
		// テキスト stripslashes

		foreach( $input as $key => $val ){
			//$new_input[$key] = $val;
			//wp_die(var_dump($new_input));

			switch( gettype( $val ) ){
				case 'string':
					$new_input[$key] = stripslashes( $val );
					break;
				case 'integer':
					$new_input[$key] = absint( $val );
					break;
			}
		}

		//wp_die(var_dump($new_input));
		return $new_input;
	}

	/**
	 * スクリプト出力
	 *
	 * @param string $page_name ページ名
	 * @return void
	 */
	public function script() {
		$options = get_option( $this->page_name() );

		if ( ! empty( $options ) && ! empty( $options['enable'] ) ) {
			if ( ! empty( $options['header'] ) ) {
				add_action(
					'wp_head',
					function() use ( $options ) {
						echo Misc::sanitize_script( $options['header'] );
					},
					$options['header_priority']
				);
			}

			if ( ! empty( $options['body_open'] ) ) {
				add_action(
					'wp_body_open',
					function() use ( $options ) {
						echo Misc::sanitize_script( $options['body_open'] );
					},
					$options['body_open_priority']
				);
			}

			if ( ! empty( $options['footer'] ) ) {
				add_action(
					'wp_footer',
					function() use ( $options ) {
						echo Misc::sanitize_script( $options['footer'] );
					},
					$options['footer_priority']
				);
			}
		}
	}

}

use hakoniwa\tools\options;
new Script();
