<?php
namespace hakoniwa\tools\options;

use hakoniwa\theme\util\Functions;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;

use hakoniwa\tools\util\Schema;

class Schemaorg {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'register_settings' ], 10 );

		// ヘッダーに出力
		add_action( 'wp_head', [ $this, 'create_meta' ], 1 );
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return Define::value( 'theme_options_name' ) . '_schema_org';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {
		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			'post_type',
			__( 'Post type to display', 'hakoniwa-tools' ),
			array( $create_form, 'checkbox_multiple' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'post_type',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'data' => Functions::get_all_post_types(),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'display_info',
			__( 'Information to be displayed', 'hakoniwa-tools' ),
			array( $create_form, 'checkbox_multiple' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => __( 'Output', 'hakoniwa-tools' ),
				'label'       => 'display_info',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'data' => array(
						'website'		=> __( 'Website', 'hakoniwa-tools' ),
						'website_type'	=> __( 'Website type (organization/individual)', 'hakoniwa-tools' ),
						'search'		=> __( 'Search', 'hakoniwa-tools' ),
						'address'		=> __( 'Address', 'hakoniwa-tools' ),
						'contactpoint'	=> __( 'Contactpoint', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'twitter',
			__( 'Twitter', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'twitter',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'facebook',
			__( 'Facebook', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'facebook',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'instagram',
			__( 'Instagram', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'instagram',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'youtube',
			__( 'YouTube', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'youtube',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'pinterest',
			__( 'Pinterest', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'pinterest',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'default_image',
			__( 'デフォルト画像', 'hakoniwa-tools' ),
			array( $create_form, 'imageUpload' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'default_image',
				'page_name'   => $this->page_name(),
				'description' => __( 'Specifies an image if no eye-catching image is set for the page', 'hakoniwa-tools' ),
			)
		);

		add_settings_field(
			'article_logo_image',
			__( 'Logo image (for articles)', 'hakoniwa-tools' ),
			array( $create_form, 'imageUpload' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'article_logo_image',
				'page_name'   => $this->page_name(),
				'description' => __( '600px(width) 60px(height) recommended', 'hakoniwa-tools' ),
			)
		);

		add_settings_field(
			'page_type',
			__( 'Type of page to post', 'hakoniwa-tools' ),
			array( $create_form, 'selectbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'page_type',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default' => 'BlogPosting',
					'data'    => array(
						'BlogPosting' => __( 'BlogPosting', 'hakoniwa-tools' ),
						'NewsArticle' => __( 'NewsArticle', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'website_type',
			__( 'Website Type', 'hakoniwa-tools' ),
			array( $create_form, 'selectbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'website_type',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default' => '',
					'data'    => array(
						''             => __( 'Unset', 'hakoniwa-tools' ),
						'Organization' => __( 'Organization', 'hakoniwa-tools' ),
						'Person'       => __( 'Person', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'person_name',
			__( 'Person name', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'person_name',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'organization_name',
			__( 'Organization name', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'organization_name',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'organization_logo_image',
			__( 'Logo image (for organization)', 'hakoniwa-tools' ),
			array( $create_form, 'imageUpload' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'organization_logo_image',
				'page_name'   => $this->page_name(),
				'description' => __( 'Width 112 x Height 112px or more', 'hakoniwa-tools' ),
			)
		);

		add_settings_field(
			'address_postalcode',
			__( 'Postal code', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'address_postalcode',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'address_addressregion',
			__( 'Addressregion', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'address_addressregion',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'address_addresslocality',
			__( 'Addresslocality', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'address_addresslocality',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'address_streetaddress',
			__( 'Address (include street number, apartment name, etc.)', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'address_streetaddress',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

		add_settings_field(
			'contactpoint_telephone',
			__( 'Contact (phone number)', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'contactpoint_telephone',
				'page_name'   => $this->page_name(),
				'description' => __( 'Country code + phone number', 'hakoniwa-tools' ),
			)
		);

		add_settings_field(
			'contactpoint_contacttype',
			__( 'Contactpoint', 'hakoniwa-tools' ),
			array( $create_form, 'selectbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'contactpoint_contacttype',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default' => '',
					'data'    => array(
						''                    => __( 'Unset', 'hakoniwa-tools' ),
						'customer service'    => __( 'Customer service', 'hakoniwa-tools' ),
						'technical support'   => __( 'Technical support', 'hakoniwa-tools' ),
						'billing support'     => __( 'Billing support', 'hakoniwa-tools' ),
						'bill payment'        => __( 'Bill payment', 'hakoniwa-tools' ),
						'sales'               => __( 'Sales', 'hakoniwa-tools' ),
						'reservations'        => __( 'Reservations', 'hakoniwa-tools' ),
						'credit card_support' => __( 'Credit card_support', 'hakoniwa-tools' ),
						'emergency'           => __( 'Emergency', 'hakoniwa-tools' ),
						'baggage tracking'    => __( 'Baggage tracking', 'hakoniwa-tools' ),
						'roadside assistance' => __( 'Roadside assistance', 'hakoniwa-tools' ),
						'package tracking'    => __( 'Package tracking', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'contactpoint_contactoption',
			__( 'Contactoption', 'hakoniwa-tools' ),
			array( $create_form, 'selectbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'contactpoint_contactoption',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default' => '',
					'data'    => array(
						''                         => __( 'Unset', 'hakoniwa-tools' ),
						'TollFree'                 => __( 'TollFree', 'hakoniwa-tools' ),
						'HearingImpairedSupported' => __( 'HearingImpairedSupported', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'contactpoint_areaserved',
			__( 'Areaserved', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'contactpoint_areaserved',
				'page_name'   => $this->page_name(),
				'description' => __( 'Country code (e.g. JP, US, etc.)', 'hakoniwa-tools' ),
			)
		);


	}

	/**
	 * 入力値のサニタイズ
	 *
	 * @param array $input Contains all settings fields as array keys
	 */
	public function sanitize( $input ) {
		$new_input = array();

//		wp_die(var_dump($input) );

		if ( isset( $input ) ) {
			foreach ( $input as $key => $val ) {
				// 配列の場合
				if ( is_array( $input[ $key ] ) ) {
					$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
				} else {
					// 通常の場合
					$new_input[ $key ] = sanitize_text_field( $input[ $key ] );
				}
			}
		}

		return $new_input;
	}

	/**
	 * JSON-LD 作成
	 *
	 */
	public function create_meta() {

		$options = get_option( $this->page_name() );

		Schema::create( $this->page_name() );

	}
}

use hakoniwa\tools\options;
new Schemaorg();
