<?php
namespace hakoniwa\tools\options;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;

class Optimize {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'register_settings' ], 10 );

		// スクリプトを読み込む
		$this->optimize_script();
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return Define::value( 'theme_options_name' ) . '_optimize';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {
		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			'front_end_jquery',
			__( 'jQuery（jquery.min.js）', Define::value( 'theme_name' ) ),
			array( $create_form, 'radio_button' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'front_end_jquery',
				'page_name'   => $this->page_name(),
				'description' => __( 'Important: Settings may not be reflected depending on the plug-ins used.', 'hakoniwa-tools' ),
				'script'      => array(
					'default' => '',
					'data'    => array(
						''        => __( 'Not loading', 'hakoniwa-tools' ),
						'footer'  => __( 'Load near the footer (around the end of the page)', 'hakoniwa-tools' ),
						'enable'  => __( 'Load', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);

		add_settings_field(
			'front_end_css',
			__( 'CSS（front-end.css）', Define::value( 'theme_name' ) ),
			array( $create_form, 'checkbox_multiple' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => __( 'Minify to reduce file size', 'hakoniwa-tools' ),
				'label'       => 'front_end_css',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'data' => array(
						'minify' => __( 'Minify to reduce file size', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);
/*
スムーススクロールしか今のところなくscroll-behaviorに実験的に変えたので一旦OFF
		add_settings_field(
			'front_end_js',
			__( 'JavaScript（front-end.js）', Define::value( 'theme_name' ) ),
			array( $create_form, 'checkbox_multiple' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => __( 'Minify to reduce file size', 'hakoniwa-tools' ),
				'label'       => 'front_end_js',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'data' => array(
						'minify' => __( 'Minify to reduce file size', 'hakoniwa-tools' ),
					),
				),
				'display_key' => false,
			)
		);
*/

	}

	/**
	 * 入力値のサニタイズ
	 *
	 * @param array $input Contains all settings fields as array keys
	 */
	public function sanitize( $input ) {
		$new_input = array();

		// wp_die(var_dump($input) );

		if ( isset( $input ) ) {
			foreach ( $input as $key => $val ) {
				// 配列の場合
				if ( is_array( $input[ $key ] ) ) {
					$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
				} else {
					// 通常の場合
					$new_input[ $key ] = stripslashes( $input[ $key ] );
				}
			}
		}

		return $new_input;
	}

	/**
	 *
	 * 表示設定チェック
	 */
	public function optimize_script() {
		$options = get_option( $this->page_name() );

		if ( empty( $options ) ) {
			add_action( 'wp_enqueue_scripts', array( $this, 'disable_jquery_frontend' ), 110 );
			return false;
		}

		// Front end CSS
		if ( ! empty( $options['front_end_css'] ) ) {
			if ( ! empty( $options['front_end_css']['minify'] ) ) {
				add_filter( Define::value( 'theme_name' ) . '_enqueue_front_end_css', array( $this, 'front_end_css' ), 100 );
			}
		}

		/*
		// Front end JS
		if ( ! empty( $options['front_end_js'] ) ) {
			if ( ! empty( $options['front_end_js']['minify'] ) ) {
				add_filter( Define::value( 'theme_name' ) . '_enqueue_front_end_js', array( $this, 'front_end_js' ), 100 );
			}
		}
		*/

		// Front end jQuery
		if ( isset( $options['front_end_jquery'] ) ) {
			if ( '' === $options['front_end_jquery'] ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'disable_jquery_frontend' ), 100 );
			}

			if ( 'footer' === $options['front_end_jquery'] || ! empty( $options['enable'] ) ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'optimize_scripts' ), 100 );
			}
		}

	}

	/**
	 * フロントエンドの CSS を最小化する
	 *
	 * @param string $url URL
	 * @return $url
	 */
	public function front_end_css( $url ) {
		$url = get_template_directory_uri() . '/assets/css/front-end.min.css';

		return $url;
	}

	/**
	 * フロントエンドの JS を最小化する
	 *
	 * @param string $url URL
	 * @return $url
	 */
	/*
	public function front_end_js( $url ) {
		$url = get_template_directory_uri() . '/assets/js/front-end.min.js';

		return $url;
	}
	*/

	/**
	 * フロントエンドの jQuery をオフにする
	 *
	 * @return void
	 */
	public function disable_jquery_frontend() {
		if ( ! is_admin() ) {
			wp_deregister_script( 'jquery' );
		}
	}

	/**
	 * 最適化実行
	 */
	public function optimize_scripts() {
		if ( ! is_admin() ) {
			wp_deregister_script( 'jquery' );
			wp_register_script( 'jquery', '/wp-includes/js/jquery/jquery.js', array(), '3.6.1', true );

			wp_enqueue_script( 'jquery' );
		}
	}

}

use hakoniwa\tools\options;
new Optimize();
