<?php
namespace hakoniwa\tools\util;

use hakoniwa\tools\init\Define;
use hakoniwa\theme\util\Functions;

class TOC {
	/**
	 * Construct.
	 */
	public function __construct() {
//		add_filter( 'the_content', [ $this, 'add_toc_anchor' ] );
//		add_action( 'fixed_content', [ $this, 'add_toc_fixed_content' ] );
	}

	/**
	 * Create TOC
	 *
	 * @param string $content 本文
	 * @return array
	 */
	public static function generate_toc( $content ) {

		// theme_option
		$options = get_option( Define::value( 'theme_options_name' ) . '_toc' );
		
		$outline               = '';
		$loop                  = 1;
		$exclude               = 0;
		$match_exclude_heading = 0;
		$display_toc           = isset ( $options['toc_enable'] ) ? true : false;
		$display_toc_fixed     = isset ( $options['toc_fixed_enable'] ) ? true : false;
		$toc_title_text        = isset ( $options['toc_label'] ) ? esc_html( $options['toc_label'] ) : '';
		$title                 = '';
		$anchor_array          = array();
		$max_level             = 2;
		$min_level             = isset ( $options['toc_heading_level'] ) ? absint( $options['toc_heading_level'] ) : 3;
		$level_array           = array_fill( 1, 6, 0 );
		$level_number          = isset ( $options['toc_heading_level_number'] ) ? absint( $options['toc_heading_level_number'] ) : 4;

		// Get Content heading.
		// h2 + h3 h[2-3]
		// h2 only h[2]
//		if ( preg_match_all( '/<h([' . $max_level . '-' . $min_level . '])(.*?)>(.*?)<\/h\1>/', $content, $matches, PREG_SET_ORDER ) ) {
		if ( preg_match_all( '/<h([' . $max_level . '-' . $min_level . '])([^>]*class="[^"]*wp-block-heading[^"]*"[^>]*)>(.*?)<\/h\1>(?![^<]*<\/h[' . $max_level . '-' . $min_level . ']>)/', $content, $matches, PREG_SET_ORDER ) ) {
			// var_dump($matches);
			// var_dump(count($matches));

			// Get the largest heading level matched headings.
			$match_max_level = intval(
				min(
					array_map(
						function( $m ) {
							return $m[1];
						},
						$matches
					)
				)
			);

			// Current level.
			$current_level = $match_max_level - 1;

			// 除外数
			$match_exclude_heading = array_sum(
				array_map(
					function( $m ) {
						if ( strpos( $m[2], 'post-title' ) !== false ) {
							return 1;
						}
					},
					$matches
				)
			);

			// 表示合計
			$show_match = count( $matches ) - $match_exclude_heading;

			$flag = false;

			// Match level count and find $max_level.
			// if ( count( $matches ) >= $level_number && $match_max_level == $max_level ) {

			if ( $show_match >= $level_number && $match_max_level === $max_level ) {
				foreach ( $matches as $m ) {
					$level      = intval( $m[1] );  // level number.
					$attributes = $m[2];  // level attribute.
					$text       = $m[3];  // level text.

					// クラスに「post-title」があれば処理をスキップ
					if ( strpos( $attributes, 'post-title' ) !== false ) {
						continue;
					}

					// When $max_level appears in the heading of the loop.
					if ( $level === $max_level ) {
						$flag = true;
					}

					if ( true === $flag ) {

						// ex. h3 > h2
						while ( $current_level > $level ) {
							--$current_level;
							$outline .= '</li></ul>';
						}

						// ex. h3 == h3
						if ( $current_level === $level ) {
							$outline .= '</li><li>';
						} else {
							while ( $current_level < $level ) {
								++$current_level;
								$outline .= sprintf( '<ul class="indent-h%s"><li>', $current_level );
							}

							$level_array_count = count( $level_array );
							for ( $idx = $current_level + 0; $idx < $level_array_count; ++$idx ) {
								$level_array[ $idx ] = 0;
							}
						}

						// Update the number of level.
						++$level_array[ $current_level ];

						// Generate path.
						$level_fullpath = array();
						for ( $idx = $match_max_level; $idx <= $level; ++$idx ) {
							$level_fullpath[] = $level_array[ $idx ];
						}

						// Anchor.

						// idの値のみ取得
						$attributes_id = preg_match_all( '/id="([^"]*)"/', $attributes, $matches_id, PREG_SET_ORDER );

						// $target_anchor = 'chapter-' . implode( '-', $level_fullpath );

						if ( $attributes_id ) {
							$target_anchor = $matches_id[0][1];
						} else {
							$target_anchor = 'chapter-' . implode( '-', $level_fullpath );
						}

						// Anchor html.
						if ( 0 === $level_fullpath[0] ) {
							++$exclude;
							$outline .= sprintf( '<a class="toc-link" href="#%s" data-' . Define::value( 'theme_name' ) . '-scroll>%s</a>', esc_attr( $target_anchor ), $text );
						} else {
							$outline .= sprintf( '<a class="toc-link" href="#%s" data-' . Define::value( 'theme_name' ) . '-scroll>%s</a>', esc_attr( $target_anchor ), $text );
						}

						// if ( $level_fullpath[0] == '0' ) {
						// ++$exclude;
						// $outline .= sprintf('<a href="#%s">%s</a>', esc_attr( $target_anchor ), esc_html( $text ) );
						// } else {
						// $outline .= sprintf('<a href="#%s">%s</a>', esc_attr( $target_anchor ), esc_html( $text ) );
						// }

						$anchor_array[] = $target_anchor;

						++$loop;

					} else {
						++$exclude;
						$anchor_array[] = '';
					}
				}

				// var_dump($anchor_array);

				// Close tags.
				while ( $current_level >= $match_max_level ) {
					$outline .= '</li></ul>';
					--$current_level;
				}
			}

			if ( $show_match >= $level_number ) {
				$title = $toc_title_text;
				// $outline = '<div class="' . Define::value( 'theme_name' ) . '-toc"><p class="title"><i class="icomoon icon-list2"></i>' . $toc_title_text . '</p>' . $outline . '</div>';
			}

			// Replace content anchor.
			// chapter 付きの見出しに置換する
			if ( ! empty( $anchor_array ) ) {
				$content = preg_replace_callback(
//					'/<h([' . $max_level . '-' . $min_level . '])(.*?)>/',
					'/<h([' . $max_level . '-' . $min_level . '])([^>]*class="[^"]*wp-block-heading[^"]*"[^>]*)>/',
					function ( $matches ) use ( &$count, $anchor_array, $exclude ) {
						$attributes = $matches[2];

						// クラスに「post-title」があれば処理をスキップ
						if ( strpos( $attributes, 'post-title' ) !== false ) {
							return '<h' . $matches[1] . $matches[2] . '>';
						}

						$count++;

						if ( $count <= $exclude ) {
							return '<h' . $matches[1] . $matches[2] . '>';
						} else {
							// idをつける
							return '<h' . $matches[1] . $matches[2] . ' id="' . $anchor_array[ $count - 1 ] . '" data-' . Define::value( 'theme_name' ) . '-toc-anchor>';
						}
					},
					$content
				);
			}

			// Generate outline.
			if ( $show_match >= $level_number && true === $display_toc && empty( get_post_meta( get_the_ID(), '_nishiki_pro_toc_disable_' . get_post_type(), true ) ) ) {

				$toc_content_title = '<p class="title"><svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-list"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l11 0" /><path d="M9 12l11 0" /><path d="M9 18l11 0" /><path d="M5 6l0 .01" /><path d="M5 12l0 .01" /><path d="M5 18l0 .01" /></svg>' . $title . '</p>';

				// Insert $outline before first $max_level.
//					if ( preg_match_all( '/<h([2])(?:.*?)>(.*?)<\/h\1>/', $content, $matches_h, PREG_SET_ORDER ) ) {
				if ( preg_match_all( '/<(\w+)(?=.*?data-' . Define::value( 'theme_name' ) . '-toc-anchor)[^>]*?>(.*?)<\/\1>/', $content, $matches_h, PREG_SET_ORDER ) ) {
					// data-' . Define::value( 'theme_name' ) . '-toc-anchor が初めに現れる見出しの後に目次挿入
					if ( $matches_h[0][0] && strpos( $matches_h[0][0], 'data-' . Define::value( 'theme_name' ) . '-toc-anchor' ) ) {
						$expand_content = '';
						$toc_class = '';

						if( $show_match >= 5 ){
							$expand_content = '<input id="readmore" type="checkbox"><label for="readmore"></label>';
							$toc_class = ' has-expand';
						}

						$content = str_replace( $matches_h[0][0], '<section id="' . Define::value( 'theme_name' ) . '-toc-content"><div class="' . Define::value( 'theme_name' ) . '-toc' . $toc_class . '">' . $expand_content . $toc_content_title . $outline . '</div></section>' . $matches_h[0][0], $content );
					}
				}
			}

		}

		return array(
			'content' => $content,
			'title'   => $title,
			'outline' => $outline,
		);
	}

	/**
	 * Add anchor.
	 *
	 * @param string $content 本文
	 * @return $content
	 */
	public static function add_toc_anchor( $content ) {
		// Add post and page(exclude front page).
		if ( ! is_singular() || is_front_page() ) {
			return $content;
		}

		$toc_meta = get_post_meta( get_the_ID(), '_' . Define::value( 'plugin_func_name' ) . '_meta_box_toc_' . get_post_type(), true );

		if( $toc_meta ){
			return $content;
		}

		// Get toc.
		$toc     = self::generate_toc( $content );
		$content = $toc['content'];

		return $content;
	}

	/**
	 * Add TOC Fixed List.
	 *
	 * @return void
	 */
	public function add_toc_fixed_content() {
		// Add post and page(exclude front page).
		if ( is_singular() || ! is_front_page() ) {
			$content = get_post_field( 'post_content', get_the_ID() );
			$toc     = self::generate_toc( $content );
			$title   = $toc['title'];
			$outline = $toc['outline'];
			$class   = [];

			if ( '' !== $outline ) {
				$toc_fixed_overlay_class = 'overlay flex fixed has-global-padding';
				?>
				<div id="<?php echo Define::value( 'theme_name' ); ?>-toc-fixed-overlay" class="<?php echo esc_html( $toc_fixed_overlay_class ); ?>">
					<div class="overlay-inner">
						<section class="hakoniwa-toc" id="toc-fixed-list">
							<p class="title"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-list"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M9 6l11 0"></path><path d="M9 12l11 0"></path><path d="M9 18l11 0"></path><path d="M5 6l0 .01"></path><path d="M5 12l0 .01"></path><path d="M5 18l0 .01"></path></svg><?php echo wp_kses_post( $title ); ?></p>
							<?php echo wp_kses_post( $outline ); ?>
						</section>
						<svg class="close" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false" aria-label="close"><path d="M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"></path></svg>
					</div>
				</div>
				<?php
			}
		}
	}

	/**
	 * Exist TOC
	 */
	public static function has_toc(){
		// Add post and page(exclude front page).
		if ( is_singular() || ! is_front_page() ) {
			$content = get_post_field( 'post_content', get_the_ID() );
			$toc     = self::generate_toc( $content );
			$outline = $toc['outline'];

			$toc_meta = get_post_meta( get_the_ID(), '_' . Define::value( 'plugin_func_name' ) . '_meta_box_toc_' . get_post_type(), true );

			if( $toc_meta ){
				return false;
			}

			if ( '' !== $outline ) {
				return true;
			} else {
				return false;
			}
		}

		return false;
	}
}

use hakoniwa\tools\util;
new TOC();