<?php
namespace hakoniwa\tools\util;

use hakoniwa\tools\init\Define;

class Misc {
	
	/**
     * Transient 削除
     */
    public static function reset_data(){

		delete_transient( Define::value( 'plugin_func_name' ) . '_check_license' );
        delete_transient( Define::value( 'plugin_func_name' ) . '_update' );

    }

	/**
	 * アップデート可能かどうかチェック
	 */
	public static function get_update_json(){
		
        $remote = get_transient( Define::value( 'plugin_func_name' ) . '_update' );
		$file = Define::value( 'update_json_file' );

		if( false === $remote ) {
			$remote = wp_remote_get(
				Define::value( 'network_auth' ) . '/' . $file,
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);
	
			if(
				is_wp_error( $remote )
				|| 200 !== wp_remote_retrieve_response_code( $remote )
				|| empty( wp_remote_retrieve_body( $remote ) )
			) {
				return false;
			}

			$remote = json_decode( wp_remote_retrieve_body( $remote ) );
			set_transient( Define::value( 'plugin_func_name' ) . '_update', $remote, 3 * HOUR_IN_SECONDS );

		}

		return $remote;
	}

	/**
	 * テーマアクティブチェック
	 */
	public static function is_activate_theme(){
		// Theme Active Check
		$theme = get_template();

		if( $theme === Define::value( 'theme_name' ) ){
			return true;
		} else {
			return false;
		}
	}

	/**
	 * スクリプトのサニタイズ
	 *
	 * @param string $text 文字列
	 * @return string
	 */
	static function sanitize_script( $text ) {

		$allowed_html = array(
			'script' => array(
				'async' => true,
				'src'   => true,
				'type'  => true
			),
			'noscript' => array(),
			'iframe'   => array(
				'src'               => true,
				'height'            => true,
				'width'             => true,
				'style'             => true,
				'frameborder'       => true,
				'allowfullscreen'   => true
			),
			'div' => array(
				'id'    => true,
				'style' => true
			)
		);

		// フィルター
		$filtered_code = wp_kses( $text, $allowed_html );

		$filter_patterns = [
			'/alert\s*\(/i',         // alert()
			'/eval\s*\(/i',          // eval()
			'/document\.write\s*\(/i', // document.write()
			'/on\w+\s*=/i',          // onclick, onmouseover など
		];
		
		$filtered_code = preg_replace( $filter_patterns, '', $filtered_code );	 

		// <script> タグ内に src 属性がないものを削除（インラインJS禁止）
		$filtered_code = preg_replace('/<script(?![^>]*\ssrc=["\']).*?<\/script>/is', '', $filtered_code);

		// "javascript:" を含む文字列を除去
		$filtered_code = preg_replace('/javascript\s*:/i', '', $filtered_code);

		return $filtered_code;
	}


}
