<?php
namespace hakoniwa\tools\options;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;

class TOC {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// オプションページ追加フック
		add_action( 'admin_menu', [ $this, 'register_settings' ], 10 );
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return Define::value( 'theme_options_name' ) . '_toc';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {
		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			'toc_enable',
			__( 'Display Table of contents', 'hakoniwa-tools' ),
			array( $create_form, 'checkbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => _x( 'Enable', 'Option:toc', 'hakoniwa-tools' ),
				'label'       => 'toc_enable',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default'     => 'true',
				),
			)
		);

		add_settings_field(
			'toc_fixed_enable',
			__( 'Display Fixed Table of contents', 'hakoniwa-tools' ),
			array( $create_form, 'checkbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => _x( 'Enable', 'Option:toc', 'hakoniwa-tools' ),
				'label'       => 'toc_fixed_enable',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default'     => 'true',
				),
			)
		);

		add_settings_field(
			'toc_heading_level',
			__( 'Minimum level of headings to display in table of contents', 'hakoniwa-tools' ),
			array( $create_form, 'selectbox' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => __( 'Minimum level of headings to display in table of contents', 'Option:toc', 'hakoniwa-tools' ),
				'label'       => 'toc_heading_level',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default'     => '3',
					'data'    => array(
						'2'	=> __( 'h2', 'hakoniwa-tools' ),
						'3'	=> __( 'h3', 'hakoniwa-tools' ),
						'4'	=> __( 'h4', 'hakoniwa-tools' ),
						'5'	=> __( 'h5', 'hakoniwa-tools' ),
						'6'	=> __( 'h6', 'hakoniwa-tools' ),
					),
				),
			)
		);

		add_settings_field(
			'toc_heading_level_number',
			__( '指定した数以上の見出しが存在する場合表示', 'hakoniwa-tools' ),
			array( $create_form, 'number' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'toc_heading_level_number',
				'page_name'   => $this->page_name(),
				'description' => '',
				'script'      => array(
					'default'     => 4,
				),
			)
		);

		add_settings_field(
			'toc_label',
			__( 'テキストラベル', 'hakoniwa-tools' ),
			array( $create_form, 'text' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       => '',
				'label'       => 'toc_label',
				'page_name'   => $this->page_name(),
				'description' => '',
			)
		);

	}

	/**
	 * 入力値のサニタイズ
	 *
	 * @param array $input Contains all settings fields as array keys
	 */
	public function sanitize( $input ) {
		$new_input = array();

		if ( isset( $input ) ) {
			foreach ( $input as $key => $val ) {
				// 配列の場合
				if ( is_array( $input[ $key ] ) ) {
					$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
				} else {
					// 通常の場合
					$new_input[ $key ] = stripslashes( $input[ $key ] );
				}
			}
		}

		return $new_input;
	}

}

use hakoniwa\tools\options;
new TOC();
