<?php
namespace hakoniwa\tools\init;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;
use hakoniwa\tools\util\Auth;

class RestApi {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'rest_api_init', array( $this, 'register_field' ) );
	}

	/**
	 * フィールドの登録
	 *
	 * @return void
	 */
	public function register_field() {

		// Add rest route.
		register_rest_route(
			'hakoniwa/tools/v1',
			'/options/(?P<name>[a-zA-Z0-9_\-]+)',
			array(
				'methods'             => ['GET', 'POST', 'PUT'],
				'callback'            => array( $this, 'callback' ),
				'permission_callback' => function () {
					return current_user_can( 'manage_options' );
				},
			)
		);
	}
	
	/**
	 * コールバック関数
	 *
	 * @param string $request 文字列
	 * @return string
	 */
	public function callback( $request ) {
		$option_name = $request['name'];
		$option_key = Define::value( 'theme_options_name' ) . '_' . $option_name;
		
		// リクエストメソッドを取得
		$method = $request->get_method();
		
		// POSTまたはPUTリクエストの場合はオプション値を更新
		if ( $method === 'POST' || $method === 'PUT' ) {
			$json_params = $request->get_json_params();
			if ( $json_params ) {
				// オプション値を更新
				update_option( $option_key, $json_params );
				// 更新後の値を取得して返す
				$updated_value = get_option( $option_key );
				return rest_ensure_response( $updated_value );
			} else {
				return new \WP_Error( 
					'invalid_params', 
					'リクエストパラメーターが不正です。', 
					array( 'status' => 400 ) 
				);
			}
		}
		
		// GETリクエストの場合は値を取得して返す
		$option_value = get_option( $option_key );
		return rest_ensure_response( $option_value );
	}

}

use hakoniwa\tools\init;
new RestApi();
