<?php
namespace hakoniwa\tools\init;

use hakoniwa\tools\init\Define;
use hakoniwa\tools\util\CreateForm;
use hakoniwa\tools\util\Auth;

class PluginAbout {

	/**
	 * product_id
	 */
	public function product_id(){
		return Define::value( 'product_id' );
	}
	
	/**
	 * Construct
	 */
	public function __construct() {

		if( true === Define::value( 'network_active' ) ){
			
			// Check License
			add_action( 'admin_notices', [ $this, 'check_license' ], 20 );

			// オプションページ追加フック
			add_action( 'admin_menu', [ $this, 'register_settings' ], 20 );

			// テーマページに追加
			if( ! has_action( Define::value( 'theme_name' ) . '_theme_about_content' ) ){
				add_action( Define::value( 'theme_name' ) . '_theme_about_content', [ $this, 'page_content' ], 10 );
			}

			// テーマページにコンテンツ追加（before）
			if( ! has_action( Define::value( 'theme_name' ) . '_theme_about_before' ) ){
				add_action( Define::value( 'theme_name' ) . '_theme_about_before', [ $this, 'license_before_content' ], 10 );
			}

			// テーマページにコンテンツ追加（after）
			if( ! has_action( Define::value( 'theme_name' ) . '_theme_about_after' ) ){
				add_action( Define::value( 'theme_name' ) . '_theme_about_after', [ $this, 'license_after_content' ], 10 );
			}

			// 入力フォーム追加
			if( ! has_action( Define::value( 'theme_name' ) . '_plugin_tools' ) ){
				add_action( Define::value( 'theme_name' ) . '_plugin_tools', [ $this, 'setting_section' ], 10 );
			}

		} else {

			add_action( 'admin_notices', [ $this, 'notice_beta' ], 20 );

		}
		
	}

	public function setting_section(){
		do_settings_sections( $this->page_name() );
	}

	public function license_before_content(){
		?>
		<h3 id="siteurl"><?php _e( 'License', 'hakoniwa-tools' ); ?></h3>
		<p><a href="https://hakoniwa.animagate.com/" target="_blank">公式サイト</a>でライセンス購入後、ライセンスキーを発行し入力してください。<a href="https://hakoniwa.animagate.com/manual/product-license-register/" target="_blank">ライセンスキー発行方法</a></p>
		<p>ライセンスキーの発行には、サイトアドレス (URL)<input tyle="text" value="<?php echo esc_url( get_option( 'home' ) ); ?>" onclick="copySiteUrl( this )" style="border:none; background:#fff; margin:0 0.2rem; padding:0.2rem 0.5rem; width:100%; max-width:240px;" readonly><span id="copied_message"></span>が必要です。</p>
		<p>ライセンス認証された製品は、新機能追加やセキュリティ対応などの「アップデート」のサービスを提供しています。</p>
		<style>
			.about-wrap .dashicons-admin-network{
				display: flex;
				align-items:center;
			}
			.about-wrap .dashicons-admin-network::before{
				vertical-align:middle;
				margin-right:0.5rem;
			}
			.about-wrap .dashicons-admin-network.active input{
				background:#99e0aa;
			}
			.about-wrap .dashicons-admin-network.active::before{
				color:#61ad73;
			}
			.about-wrap .dashicons-admin-network.deactive input{
				background:#e9c972;
			}
			.about-wrap .dashicons-admin-network.deactive::before{
				color:#dba616;
			}
		</style>
		<script>
			function copySiteUrl(e) {
				const checkContent = document.getElementById( 'site-url-copied' );
				if( !! checkContent ){
					checkContent.remove();
				}

				e.select();
				navigator.clipboard.writeText( e.value );

				const newContent = document.createElement( 'span' );

				newContent.classList.add( 'copied' );
				newContent.setAttribute( 'id', 'site-url-copied' );
				newContent.style.display = 'inline';
				newContent.style.backgroundColor = '#fefefe';
				newContent.style.padding = '0.2rem 0.5rem';
				newContent.style.margin = '0 0.5rem';

				const newText = document.createTextNode( 'URL をコピーしました' );

				newContent.appendChild( newText );

				const currentDiv = document.getElementById( 'siteurl' );
				currentDiv.appendChild( newContent );

				setTimeout( function() {
					newContent.remove();
				}, 2000 );							
			}
		</script>
		<?php
	}

	public function license_after_content(){
		?>
		<h4>ライセンス認証できない場合</h4>
		<ul>
			<li>・ライセンスキーの入力ミスがないか確認してください。</li>
			<li>・ライセンスキーの有効期限が切れている場合があります。サブスクリプション版の場合は、ライセンスキーの有効期限を延長してください。</li>
		</ul>
		<?php
	}

	public function page_content(){
		?>
		<form method="post" action="options.php">
			<?php 
				settings_fields( $this->page_name() );
				do_action( Define::value( 'theme_name' ) . '_plugin_tools' );
//				do_settings_sections( $this->page_name() );
				submit_button();
			?>
		</form>
		<?php
	}

	/**
	 * ページ名
	 */
	public function page_name(){
		return 'theme_about';
	}

	/**
	 * フォーム追加
	 */
	public function register_settings() {

		if( 'GET' === $_SERVER['REQUEST_METHOD'] && isset( $_GET['settings-updated'] ) ){
			delete_transient( Define::value( 'plugin_func_name' ) . '_check_license' );
		}

		$create_form = new CreateForm;

		register_setting(
			$this->page_name(),
			$this->page_name(),
			array( $this, 'sanitize' )
		);

		add_settings_section(
			$this->page_name(),
			'',
			array( $create_form, 'nonce' ),
			$this->page_name()
		);

		add_settings_field(
			Define::value( 'plugin_func_name' ) . '_license_key',
			__( 'Tools（plugin）', 'hakoniwa-tools' ),
			array( $create_form, 'license' ),
			$this->page_name(),
			$this->page_name(),
			array(
				'title'       	=> '',
				'label'       	=> Define::value( 'plugin_func_name' ) . '_license_key',
				'page_name'   	=> $this->page_name(),
				'option_name'	=> Define::value( 'plugin_func_name' ),
				'product_id'	=> self::product_id()
			)
		);

	}

	/**
	 * ベータ版表示
	 */
	public function notice_beta(){
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}

		// プラグイン情報を取得
		$plugin_data = get_plugin_data( Define::value( 'plugin_path' ) . Define::value( 'plugin_base_file' ), false, false );

		$message = sprintf( __( '%1$s is currently being distributed as a beta version, and we are offering the service of updating it free of charge.', 'hakoniwa-tools' ), $plugin_data['Name'] );
		echo '<div class="update-nag notice notice-warning inline hakoniwa-notice">' . $message . '</div>';
	}

	/**
	 * スケジュール追加
	 */
	public function check_license(){

		// 一日1回認証チェックする
        $response = get_transient( Define::value( 'plugin_func_name' ) . '_check_license' );

		if( false === $response ) {

			// オプション取得
			$option			= get_option( 'theme_about' );

			$license_key    = isset( $option[Define::value( 'plugin_func_name' ) . '_license_key'] ) ? $option[Define::value( 'plugin_func_name' ) . '_license_key'] : '';
	
			// 認証
			$remote_response = new Auth();

			$args = array(
				'url'	=> get_option( 'home' ),
				'key'	=> $license_key
			);

			$response = $remote_response->remote_check( $args );

			set_transient( Define::value( 'plugin_func_name' ) . '_check_license', $response, 3 * HOUR_IN_SECONDS );

		}

//		var_dump($response);

		// レスポンスの内容で処理を変える
		if( $response == false ){

			// アクティベートをfalseにする
			$args = [
				'status' => false,
				'data' => $response,
			];

			update_option( Define::value( 'plugin_func_name' ) . '_activate', $args );

		} elseif( isset( $response['active'] ) && $response['active'] == true ){

			// アクティベートをtrueにする
			$args = [
				'status' => true,
				'data' => $response
			];

			// 製品 ID が合っていればデータを更新
			if( self::product_id() !== $response['product_id'] ){

				// アクティベートをfalseにする
				$args = [
					'status' => false,
					'data' => $response
				];

			}

			update_option( Define::value( 'plugin_func_name' ) . '_activate', $args );

		}

		$activate_option = get_option( Define::value( 'plugin_func_name' ) . '_activate' );

		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}

		// プラグイン情報を取得
		$plugin_data = get_plugin_data( Define::value( 'plugin_path' ) . Define::value( 'plugin_base_file' ), false, false );

		// ステータスによって表示内容を変える
		if( empty( $activate_option[ 'status' ] ) | false == $activate_option[ 'status' ] ){
			$message = $plugin_data['Name'] . __( ':License is not activated. When the license is activated, the "Add New Features" and "Security Update" services will be available.', 'hakoniwa-tools' );
		}

		if( ! empty( $message ) ){
			$this->notice_create_license( $message );
		}
		
//		var_dump($option);
//		var_dump($response);
	}

	/**
	 * メッセージ表示
	 */
	public function notice_create_license( $message ){

		$create_date = date_i18n("Y-n-j H:i:s");
		$message .=  '(' . __( 'Last checked:', 'hakoniwa-tools' ) . $create_date . ')';

		echo '<div class="update-nag notice notice-warning inline hakoniwa-notice">' . $message . '</div>';
	}

}

use hakoniwa\tools\init;
new PluginAbout();
