<?php
namespace hakoniwa\tools\init;

class Define {

	/**
	 * 定数
	 */
	public static function value( $name ){
		
		if( empty( $name ) ){
			return false;
		}

		switch( $name ){
			case 'theme_name':

				$define = 'hakoniwa';

				break;

			case 'theme_options_name':

				$define = 'hakoniwa_options';

				break;
	
			case 'network_auth':

				$define = 'https://hakoniwa.animagate.com';

				break;

			case 'network_active':

				$define = true;

				break;

			case 'product_id':

				$define = 'prod_OqDEXYcSfGUCcC';
//				$define = 'prod_O7zyeo3DU9Y65N'; // テスト用

				break;	

			case 'update_json_file':

				$define = '/wp/packages/plugins/hakoniwa-tools/plugin-info.json';

				break;
		
			case 'plugin_name':

				$define = 'hakoniwa-tools';

				break;

			case 'plugin_func_name':

				$define = 'hakoniwa_tools';

				break;

			case 'plugin_url':

				$define = plugin_dir_url( dirname( __DIR__ ) );

				break;
			
			case 'plugin_path':

				$define = plugin_dir_path( dirname( __DIR__ ) );

				break;

			case 'plugin_base_file':

				$define = 'index.php';

				break;

			case 'plugin_base_name':

				$define = plugin_basename( dirname( __FILE__, 3 ) );

				break;

			default:

				$define = '';

				break;
		}

		return $define;
	}	
}

