<?php
namespace hakoniwa\tools\init;

use hakoniwa\tools\init\Define;

class Scripts {
	
	/**
	 * Constructor
	 */
	public function __construct() {

		add_action( 'wp_enqueue_scripts', [ $this, 'read_scripts' ] );
		
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_read_scripts' ] );

	}

	/**
	 * Enqueue Front End Scripts & Styles
	 */
	public function read_scripts() {
		$theme_version  = wp_get_theme()->get( 'Version' );
		$version_string = is_string( $theme_version ) ? $theme_version : false;

		// Add CSS
		wp_register_style( Define::value( 'plugin_name' ) . '-front-end', Define::value( 'plugin_url' ) . 'assets/css/front-end.css', [], '1.0.0', 'all' );
		wp_enqueue_style( Define::value( 'plugin_name' ) . '-front-end' );

		// Add Script
		$front_end_js = apply_filters( Define::value( 'plugin_name' ) . '_enqueue_front_end_js', Define::value( 'plugin_url' ) . 'assets/js/' . Define::value( 'plugin_name' ) . '.js' );

		wp_register_script( Define::value( 'plugin_name' ), $front_end_js, array(), $version_string, true );
		wp_enqueue_script( Define::value( 'plugin_name' ) );

	}

	/**
	 * Admin Style & Script
	 */
	public function admin_read_scripts() {

		$current_screen = get_current_screen();

		// Add Admin CSS
		$get_page = ! empty( $_GET['page'] ) ? htmlspecialchars( $_GET['page'] ) : '';
			
		if ( Define::value( 'theme_name' ) . '-tools.php' === $get_page ) {

			wp_register_style( Define::value( 'plugin_name' ) . '-admin', Define::value( 'plugin_url' ) . 'assets/css/admin.css', [], '1.0.0', 'all' );
			wp_enqueue_style( Define::value( 'plugin_name' ) . '-admin' );

		}
		
		// Add Localize
		$localize_data = [ 
			'themeName' => Define::value( 'theme_name' )
		];
		
		wp_localize_script( 'common', 'object', $localize_data );

		// Add Color Picker
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( Define::value( 'plugin_name' ) . '-color-picker', Define::value( 'plugin_url' ) . 'assets/js/color-picker.js', [ 'wp-color-picker' ], '1.0.0', true );
		
		// Image Loader
		if ( ! did_action( 'wp_enqueue_media' ) ) {

			wp_enqueue_media();

		}

		wp_enqueue_script( Define::value( 'plugin_name' ) . '-media-uploader', Define::value( 'plugin_url' ) . 'assets/js/media-uploader.js', [ 'jquery' ], '1.0.0', true );
		
	}
	
}

use hakoniwa\tools\init;
new Scripts();
