(function () {
	'use strict';

	/**
	 * Scroll Top Button
	 *
	 */
	function hakoniwaScrollTopButton() {
	  var button = document.getElementById('scroll-page-top');
	  if (!!button) {
	    window.addEventListener('scroll', function () {
	      var e = window.pageYOffset || document.documentElement.scrollTop;
	      setTimeout(function () {
	        if (e > 100) {
	          button.classList.add('show');
	        } else {
	          button.classList.remove('show');
	        }
	      }, 100);
	    }, false);
	  }
	}

	/**
	 * functions
	 *
	 */
	function overlayOutsideClose(element, outside, func) {
	  if (element) {
	    element.addEventListener('click', function (event) {
	      if (!event.target.closest(outside)) {
	        if (element.classList.contains('is-open')) {
	          func();
	        }
	      }
	    });
	  }
	}

	/**
	 * TOC
	 *
	 */
	function hakoniwaTOCButton() {
	  var button = document.getElementById('fixed-toc');
	  var tocFixedOverlay = document.getElementById('hakoniwa-toc-fixed-overlay');
	  if (!!button) {
	    var hakoniwaFixedTOCClose = function hakoniwaFixedTOCClose() {
	      if (!!tocFixedOverlay) {
	        tocFixedOverlay.classList.remove('is-open');
	      }
	    };
	    window.addEventListener('scroll', function () {
	      var e = window.pageYOffset || document.documentElement.scrollTop;
	      setTimeout(function () {
	        if (e > 100) {
	          button.classList.add('show');
	        } else {
	          button.classList.remove('show');
	        }
	      }, 100);
	    }, false);
	    button.addEventListener('click', function () {
	      tocFixedOverlay.classList.add('is-open');
	    });
	    if (!!tocFixedOverlay) {
	      var tocFixedLinks = tocFixedOverlay.querySelectorAll('a');
	      tocFixedLinks.forEach(function (link, j) {
	        link.addEventListener('click', function () {
	          tocFixedOverlay.classList.remove('is-open');
	        });
	      });
	    }

	    /** オーバーレイ閉じる */
	    overlayOutsideClose(tocFixedOverlay, '#hakoniwa-toc-fixed-overlay.is-open ul', hakoniwaFixedTOCClose);
	  }
	}

	/** Init（ドキュメントを全部読み込んだ後の設定） */

	function hakoniwaInit() {
	  /** スクロールトップボタン */
	  hakoniwaScrollTopButton();

	  /** TOC */
	  hakoniwaTOCButton();
	}

	/** 最初に読み込む */
	document.addEventListener('DOMContentLoaded', hakoniwaInit);

})();
